#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_rabbitmq()
{
    log_info "begin rabbitmq Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old rabbitmq"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new rabbitmq"
    sh "${CURRENT_PATH}/config.sh"
    CHECK_RESULT $? "failed to config new rabbitmq"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new rabbitmq"
    log_info "Finish rabbitmq Upgrade action."
}

log_info "begin rabbitmq Upgrade."
upgrade_rabbitmq
touch "${CURRENT_PATH}/rabbitmq_upgrade_finish"
log_info "Upgrade rabbitmq success."