#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function config_zookeeper()
{
    (
        echo "from basesdk import reset_acl"
        echo "from basesdk import utils"
        echo "try:"
        echo "    zk_nodes = utils.get_info('zookeeper_nodes')"
        echo "    exit(reset_acl.config_zookeeper(zk_nodes,'set_acl'))"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}
cmd_retry "config_zookeeper" 30 10
CHECK_RESULT $? "Config zookeeper acl failed"
log_info "config_zookeeper success"