#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

log_info "Start zookeeper..."
zookeeper_auth_info=$(get_cms_info "$1")
zookeeper_auth=$(get_dict_info "${zookeeper_auth_info}" "zookeeper_auth")
if [[ -n "${zookeeper_auth}" ]];then
    sed -i "s/authData=.*/authData=${zookeeper_auth}/" /opt/huawei/dj/etc/zookeeper/zkClient.conf

else
    zookeeper_auth=$(awk '{print $NF}' /opt/huawei/dj/DJSecurity/privkey/privkey.conf)
    sed -i "s/authData=.*/authData=${zookeeper_auth}/" /opt/huawei/dj/etc/zookeeper/zkClient.conf
fi

decrypt_zk_passpwd=$(decrypt_pwd "${zookeeper_auth}")
zk_passpwd_hash=$(hash_password "${decrypt_zk_passpwd}")

# hash 中可能包含 /, 会和 sed / 冲突，改用 |
sed -i "s|authDataHash=.*|authDataHash=${zk_passpwd_hash}|" /opt/huawei/dj/etc/zookeeper/zkClient.conf
CHECK_RESULT $? "Config authDataHash failed"

sudo -u openstack /opt/huawei/dj/sbin/zookeeperControl -A RESTART
CHECK_RESULT $? "Start zookeeper failed"
log_info "start zookeeper successfully."