#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"


function upgrade_zookeeper()
{
    log_info "begin zookeeper Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old zookeeper"
    sh "${CURRENT_PATH}/merge.sh"
    CHECK_RESULT $? "failed to merge new zookeeper"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new zookeeper"
    sh "${CURRENT_PATH}/config.sh"
    CHECK_RESULT $? "failed to install config zookeeper"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new zookeeper"
    log_info "Finish zookeeper Upgrade action."
}

log_info "begin zookeeper Upgrade."
upgrade_zookeeper
touch "${CURRENT_PATH}/zookeeper_upgrade_finish"
log_info "Upgrade zookeeper success."