#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
source /opt/huawei/dj/inst/utils.sh
source ${CURRENT_PATH}/utils.sh

set -e

if [[ ${UID} -ne 0 ]]; then
    echo "Please switch to user(root) for run." && exit 1
fi

function install_base_root_tools() {
    rm -rf "${PATCH_BASE_PATH}"/820SPC500 "${PATCH_BASE_PATH}"/830 "${PATCH_BASE_PATH}"/remediate_iptables_conf.sh
    mkdir -p "${PATCH_BASE_PATH}" "${PATCH_BASE_PATH}"/820SPC500 "${PATCH_BASE_PATH}"/830
    chmod 700 -R "${PATCH_BASE_PATH}"
    /usr/bin/cp -f "${CURRENT_PATH}"/patch_file/base/remediate_iptables_conf.sh "${PATCH_BASE_PATH}"/remediate_iptables_conf.sh
    /usr/bin/cp -f "${CURRENT_PATH}"/patch_file/base/820SPC500/modify_iptables_conf.sh "${PATCH_BASE_PATH}"/820SPC500/modify_iptables_conf.sh
    /usr/bin/cp -f "${CURRENT_PATH}"/patch_file/base/830/modify_iptables_conf.sh "${PATCH_BASE_PATH}"/830/modify_iptables_conf.sh
    find "${PATCH_BASE_PATH}" -type f -name "*.sh" | xargs chmod 500
}

function config_base_root_tools() {
    echo "Start to config base root tools."
    case "${CURRENT_VERSION}" in
    "8.2.0.SPC500")
        manage_ip_list=$(get_info.py manage_ip list)
        ;;
    "8.2.0.SPH503")
        manage_ip_list=$(get_info.py manage_ip list)
        ;;
    *)
        manage_ip_list=$(get_info manage_ip_list)
        ;;
    esac
    sed -i "s#MANAGE_IP_LIST#${manage_ip_list}#g" "${PATCH_BASE_PATH}"/820SPC500/modify_iptables_conf.sh
    CHECK_RESULT $? "Config 820SPC500 modify_iptables_conf.sh MANAGE_IP_LIST failed!"
    sed -i "s#MANAGE_IP_LIST#${manage_ip_list}#g" "${PATCH_BASE_PATH}"/830/modify_iptables_conf.sh
    CHECK_RESULT $? "Config 830 modify_iptables_conf.sh failed!"
    echo "Finish to config base root tools."
}

function config_crontab() {
    sed -i '\/opt\/huawei_patch\/root_tools\/base\/remediate_iptables_conf.sh/d' /etc/crontab
    echo "*/2 * * * * root /bin/bash /opt/huawei_patch/root_tools/base/remediate_iptables_conf.sh > /dev/null 2>&1" >> /etc/crontab
}

function install_remediate_iptables_tool() {
    install_base_root_tools
    config_base_root_tools
    config_crontab
    "${PATCH_BASE_PATH}"/remediate_iptables_conf.sh
}

function configure_sudo_log_archive()
{
    echo "Configure sudo.log archiving."
    local syslog_logrotate_path="/etc/logrotate.d/syslog"
    local rsyslog_logrotate_path="/etc/logrotate.d/rsyslog"
    local bak_logrotate_path="${BACKUP_FILE_PATH}"/"${CURRENT_VERSION}"/logrotate
    mkdir -p "${bak_logrotate_path}"
    if [ -f "${syslog_logrotate_path}" ]; then
        /usr/bin/cp -np "${syslog_logrotate_path}" "${bak_logrotate_path}"
    fi
    if [ -f "${rsyslog_logrotate_path}" ]; then
        /usr/bin/cp -np "${rsyslog_logrotate_path}" "${bak_logrotate_path}"
    fi

    local sudo_log_path="/var/log/sudo.log"
    local cron_log_path="/var/log/cron"
    if [ -f "${syslog_logrotate_path}" ] && (grep -q "${cron_log_path}" "${syslog_logrotate_path}") && ! (grep -q "${sudo_log_path}" "${syslog_logrotate_path}");then
        sed -i "/\/var\/log\/cron/a\/var\/log\/sudo.log" "${syslog_logrotate_path}"
    fi
    if [ -f "${rsyslog_logrotate_path}" ] && (grep -q "${cron_log_path}" "${rsyslog_logrotate_path}") && ! (grep -q "${sudo_log_path}" "${rsyslog_logrotate_path}");then
        sed -i "/\/var\/log\/cron/a\/var\/log\/sudo.log" "${rsyslog_logrotate_path}"
    fi
    echo "The sudo.log archiving is configured."
}

function upgrade_karbor() {
    echo "Start to install the karbor patch."
    local bak_karbor_path="${BACKUP_FILE_PATH}"/"${CURRENT_VERSION}"/karbor
    mkdir -p "${bak_karbor_path}"
    /usr/bin/cp -np "${SITE_PACKAGES}"/kangaroo/plugin/volume/backup_operation.py "${bak_karbor_path}"
    /usr/bin/cp -np "${SITE_PACKAGES}"/kangaroo/plugin/utils/backup_utils.py "${bak_karbor_path}"
    /usr/bin/cp -np "${SITE_PACKAGES}"/kangaroo/plugin/utils/delete_utils.py "${bak_karbor_path}"
    /usr/bin/cp -np "${SITE_PACKAGES}"/kangaroo/operationtools/report/report_context.py "${bak_karbor_path}"
    /usr/bin/cp -np /opt/huawei/dj/etc/karbor/report/report_mapping.json "${bak_karbor_path}"
    echo "Script backed up successfully."
    /usr/bin/cp -f "${CURRENT_PATH}"/patch_file/kangaroo/backup_operation.py "${SITE_PACKAGES}"/kangaroo/plugin/volume/backup_operation.py
    /usr/bin/cp -f "${CURRENT_PATH}"/patch_file/kangaroo/backup_utils.py "${SITE_PACKAGES}"/kangaroo/plugin/utils/backup_utils.py
    /usr/bin/cp -f "${CURRENT_PATH}"/patch_file/kangaroo/delete_utils.py "${SITE_PACKAGES}"/kangaroo/plugin/utils/delete_utils.py
    /usr/bin/cp -f "${CURRENT_PATH}"/patch_file/kangaroo/report_context.py "${SITE_PACKAGES}"/kangaroo/operationtools/report/report_context.py
    sed -i 's/Resource Set/Resource Space/g' /opt/huawei/dj/etc/karbor/report/report_mapping.json
    echo "The karbor patch is installed successfully."
}

function install_820SPC500_patch() {
    echo "Start to install ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
    install_remediate_iptables_tool
    echo "Succeeded to install ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
}

function install_830_patch() {
    echo "Start to install ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
    install_remediate_iptables_tool
    echo "Succeeded to install ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
}

function install_831_patch() {
    echo "Start to install ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
    install_remediate_iptables_tool
    configure_sudo_log_archive
    echo "Succeeded to install ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
}

function install_850_patch() {
    echo "Start to install ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
    install_remediate_iptables_tool
    configure_sudo_log_archive
    upgrade_karbor
    restart_karbor_service
    echo "Succeeded to install ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
}

function pre_install_path() {
    if [ ! -d "${BACKUP_FILE_PATH}" ]; then
        mkdir -p "${BACKUP_FILE_PATH}"
    fi
    if [ ! -d "${PATCH_VERSION_PATH}" ]; then
        mkdir -p "${PATCH_VERSION_PATH}"
    fi
}

function main() {
    local installed_patch=$(cat "${PATCH_VERSION_FILE}" 2>/dev/null | grep "${PATCH_VERSION}" | wc -l)
    if [[ "${installed_patch}" -eq 1 ]]; then
        echo "The patch has been installed."
        exit 0
    fi
    pre_install_path
    case "${CURRENT_VERSION}" in
    "8.2.0.SPC500")
        install_820SPC500_patch
        ;;
    "8.2.0.SPH503")
        install_820SPC500_patch
        ;;
    "8.3.0")
        install_830_patch
        ;;
    "8.3.1")
        install_831_patch
        ;;
    "8.5.0")
        install_850_patch
        ;;
    *)
        echo "This patch does not need to be installed in current version, the current version is ${CURRENT_VERSION}."
        ;;
    esac
    echo "$(date +"%Y-%m-%d %H:%M:%S") ${PATCH_VERSION}" >> "${PATCH_VERSION_FILE}"
    echo 'Install patch successfully.'
}

main
