#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo "$(readlink -f "$0")" "$@";exit $?
fi
# 外部输入参数使用前需要校验
[[ $# -ne 0 ]] && exit 1

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="DJServiceControl"
CURRENT_VERSION=$(cat /opt/huawei/dj/cfg/dj.version | grep SHORT_VERSION | cut -d '=' -f 2)
PATCH_BASE_PATH="/opt/huawei_patch/root_tools/base"
SERVICE_LIST=("omm-ha" "zookeeper" "alarm" "cps-monitor" "cms" "scagent" "rabbitmq" "haproxy"
"karbor-api" "karbor-protection" "karbor-operation" "resource_manager")

function restart_service() {
    echo_info "Begin to restart backup service..."
    for service in "${SERVICE_LIST[@]}";do
        if [[ "${CURRENT_VERSION}" = "8.2.0.SPC500" || "${CURRENT_VERSION}" = "8.2.0.SPH503" ]]; then
            service_control="/usr/bin/${service}Control"
        else
            service_control="/opt/huawei/dj/sbin/${service}Control"
        fi
        if [[ ! -L "${service_control}" ]];then
            continue
        fi
        cmd_retry "${service}Control -A RESTART" 10 5
        if [[ "$?" -ne 0 ]]; then
            echo_error "Restart ${service} failed!"
        else
            echo_info "Restart ${service} success."
        fi
    done
    echo_info "Restart backup service finish."
}

function remediate_820SPC500() {
    local ip_start=$(iptables -L | grep -m1 "source IP range" | awk '{print $9}' | cut -d'-' -f1)
    local ip_end=$(iptables -L | grep -m1 "source IP range" | awk '{print $9}' | cut -d'-' -f2)
    if [ "${ip_start}" \> "${ip_end}" ]; then
        "${PATCH_BASE_PATH}"/820SPC500/modify_iptables_conf.sh > /dev/null 2>&1
        restart_service
    fi
}

function remediate_830() {
    local ip_start=$(iptables -L | grep -m1 "source IP range" | awk '{print $9}' | cut -d'-' -f1)
    local ip_end=$(iptables -L | grep -m1 "source IP range" | awk '{print $9}' | cut -d'-' -f2)
    if [ "${ip_start}" \> "${ip_end}" ]; then
        "${PATCH_BASE_PATH}"/830/modify_iptables_conf.sh > /dev/null 2>&1
        restart_service
    fi
}

function remediate_851SPC100() {
    sleep 300
    sed -i '\/opt\/huawei_patch\/root_tools\/base\/remediate_iptables_conf.sh/d' /etc/crontab
    rm -rf "${PATCH_BASE_PATH}"
}

case "${CURRENT_VERSION}" in
    "8.2.0.SPC500")
        remediate_820SPC500
        ;;
    "8.2.0.SPH503")
        remediate_820SPC500
        ;;
    "8.3.0")
        remediate_830
        ;;
    "8.3.1")
        remediate_830
        ;;
    "8.5.0")
        remediate_830
        ;;
    "8.5.1.SPC100")
        remediate_851SPC100
        ;;
    *)
        echo "Not need to remediate, the current version is ${karbor_version}."
        ;;
esac
