#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
source /opt/huawei/dj/inst/utils.sh
source ${CURRENT_PATH}/utils.sh

set -e

if [[ ${UID} -ne 0 ]]; then
    echo "Please switch to user(root) for run." && exit 1
fi

function rollback_base_root_tools() {
    rm -rf "${PATCH_BASE_PATH}"/820SPC500 "${PATCH_BASE_PATH}"/830 "${PATCH_BASE_PATH}"/remediate_iptables_conf.sh
}

function config_crontab() {
    sed -i '\/opt\/huawei_patch\/root_tools\/base\/remediate_iptables_conf.sh/d' /etc/crontab
}

function rollback_iptables_config() {
    /opt/huawei/root_tools/base/modify_iptables_conf.sh >/dev/null 2>&1
    local ip_start=$(iptables -L | grep -m1 "source IP range" | awk '{print $9}' | cut -d'-' -f1)
    local ip_end=$(iptables -L | grep -m1 "source IP range" | awk '{print $9}' | cut -d'-' -f2)
    if [ "${ip_start}" \> "${ip_end}" ]; then
        iptables -F
    fi
}

function rollback_sudo_log_archive()
{
    local bak_logrotate_path="${BACKUP_FILE_PATH}"/"${CURRENT_VERSION}"/logrotate
    if [ -f "${bak_logrotate_path}"/syslog ]; then
        /usr/bin/cp -f "${bak_logrotate_path}"/syslog /etc/logrotate.d
    fi
    if [ -f "${bak_logrotate_path}"/rsyslog ]; then
        /usr/bin/cp -f "${bak_logrotate_path}"/rsyslog /etc/logrotate.d
    fi
}

function rollback_karbor() {
    echo "Start to rollback the karbor patch."
    local bak_karbor_path="${BACKUP_FILE_PATH}"/"${CURRENT_VERSION}"/karbor
    if [ ! -d "${bak_karbor_path}" ]; then
        echo "The karbor backup file path does not exist. Rollback cannot be performed."
        exit 1
    fi
    /usr/bin/cp -f "${bak_karbor_path}"/backup_operation.py "${SITE_PACKAGES}"/kangaroo/plugin/volume/backup_operation.py
    /usr/bin/cp -f "${bak_karbor_path}"/backup_utils.py "${SITE_PACKAGES}"/kangaroo/plugin/utils/backup_utils.py
    /usr/bin/cp -f "${bak_karbor_path}"/delete_utils.py "${SITE_PACKAGES}"/kangaroo/plugin/utils/delete_utils.py
    /usr/bin/cp -f "${bak_karbor_path}"/report_context.py "${SITE_PACKAGES}"/kangaroo/operationtools/report/report_context.py
    /usr/bin/cp -f "${bak_karbor_path}"/report_mapping.json /opt/huawei/dj/etc/karbor/report/report_mapping.json
    echo "The karbor patch is rollbacked successfully."
}

function rollback_820SPC500_patch() {
    echo "Start to uninstall ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
    config_crontab
    rollback_base_root_tools
    rollback_iptables_config
    echo "Succeeded to uninstall ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
}

function rollback_830_patch() {
    echo "Start to uninstall ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
    config_crontab
    rollback_base_root_tools
    rollback_iptables_config
    echo "Succeeded to uninstall ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
}

function rollback_831_patch() {
    echo "Start to uninstall ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
    config_crontab
    rollback_base_root_tools
    rollback_iptables_config
    rollback_sudo_log_archive
    echo "Succeeded to uninstall ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
}

function rollback_850_patch() {
    echo "Start to uninstall ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
    config_crontab
    rollback_base_root_tools
    rollback_iptables_config
    rollback_sudo_log_archive
    rollback_karbor
    restart_karbor_service
    echo "Succeeded to uninstall ${PATCH_VERSION} patch for ${CURRENT_VERSION}."
}

function main() {
    local installed_patch=$(cat "${PATCH_VERSION_FILE}" 2>/dev/null | grep "${PATCH_VERSION}" | wc -l)
    if [[ "${installed_patch}" -lt 1 ]]; then
        echo "The patch is not installed. Rollback is not required."
        exit 0
    fi
    case "${CURRENT_VERSION}" in
    "8.2.0.SPC500")
        rollback_820SPC500_patch
        ;;
    "8.2.0.SPH503")
        rollback_820SPC500_patch
        ;;
    "8.3.0")
        rollback_830_patch
        ;;
    "8.3.1")
        rollback_831_patch
        ;;
    "8.5.0")
        rollback_850_patch
        ;;
    *)
        echo "This patch does not need to be rollbacked in current version, the current version is ${CURRENT_VERSION}."
        ;;
    esac
    sed -i "/${PATCH_VERSION}/d" "${PATCH_VERSION_FILE}"
    echo 'Rollback patch successfully.'
    exit 0
}

main
