#!/bin/bash
PATCH_VERSION="8.5.1.SPC100"
PATCH_PATH=/opt/huawei_patch
BACKUP_FILE_PATH="${PATCH_PATH}"/backup
PATCH_VERSION_PATH="${PATCH_PATH}"/dj/versions
PATCH_BASE_PATH="${PATCH_PATH}"/root_tools/base
CURRENT_VERSION=$(cat /opt/huawei/dj/cfg/dj.version | grep SHORT_VERSION | cut -d '=' -f 2)
SITE_PACKAGES="/opt/huawei/dj/bin/python/lib/python3.10/site-packages"
PATCH_VERSION_FILE="${PATCH_VERSION_PATH}"/"${CURRENT_VERSION}"_patch.ver

function CHECK_RESULT()
{
    [[ "$1" -ne 0 ]] && echo "$2" && exit "$1"
    return 0
}
##############################################################
# 功能说明: 重启Karbor所有服务
# 入   参:
#
##############################################################
function restart_karbor_service() {
    karbor-apiControl -A RESTART && karbor-protectionControl -A RESTART && karbor-operationControl -A RESTART
    CHECK_RESULT $? "Failed to restart the Karbor service."
}
###############################################################
# 功能说明: 公共方法-->命令重试执行
# 入    参: $1 cmd
#          $2 重试次数
#          $3 重试间隔
##############################################################
function cmd_retry()
{
    if [[ $# -ne 3 ]]; then
        return 2
    fi
    local cmd=$1
    local retry_count=$2
    local retry_interval=$3
    for i in `seq ${retry_count}`
    do
        eval ${cmd}
        if [ $? -eq 0 ]; then
            return 0
        fi
        if [ $i -ne ${retry_count} ]; then
            sleep ${retry_interval}
        fi
    done
    return 1
}
##############################################################
# 功能说明: 启动karbor-api服务
# 入    参:
##############################################################
function start_karbor_api() {
    cmd_retry "karbor-apiControl -S RUN" 5 10 >/dev/null 2>&1
    CHECK_RESULT $? "Start karbor-api failed."
}
##############################################################
# 功能说明: 启动karbor-operation服务
# 入    参:
##############################################################
function start_karbor_operation() {
    cmd_retry "karbor-operationControl -S RUN" 5 10 >/dev/null 2>&1
    CHECK_RESULT $? "Start karbor-operation failed."
}
##############################################################
# 功能说明: 启动karbor-protection服务
# 入    参:
##############################################################
function start_karbor_protection() {
    cmd_retry "karbor-protectionControl -S RUN" 5 10 >/dev/null 2>&1
    CHECK_RESULT $? "Start karbor-protection failed."
}
##############################################################
# 功能说明: 停止karbor-api服务
# 入    参:
##############################################################
function stop_karbor_api() {
    cmd_retry "karbor-apiControl -S STOP" 5 10 >/dev/null 2>&1
    CHECK_RESULT $? "Stop karbor-api failed."
}
##############################################################
# 功能说明: 停止karbor-operation服务
# 入    参:
##############################################################
function stop_karbor_operation() {
    cmd_retry "karbor-operationControl -S STOP" 5 10 >/dev/null 2>&1
    CHECK_RESULT $? "Stop karbor-operation failed."
}
##############################################################
# 功能说明: 停止karbor-protection服务
# 入    参:
##############################################################
function stop_karbor_protection() {
    cmd_retry "karbor-protectionControl -S STOP" 5 10 >/dev/null 2>&1
    CHECK_RESULT $? "Stop karbor-protection failed."
}
