#!/bin/bash
version_file=$(cat /opt/huawei/dj/cfg/dj.version)
karbor_version=${version_file##*=}

if [[ ${UID} -ne 0 ]]; then
    echo "Please switch to user(root) for run." && exit 1
fi
CURRENT_PATH=$(dirname $(readlink -f $0))

function rollback_851SPC100_patch() {
    tar -P -xzf "${CURRENT_PATH}"/OceanStor_BCManager_8.5.1.SPC100_Patch.tar.gz >/dev/null 2>&1
    find "${CURRENT_PATH}" -type f -name "*.py" -o -name "*.sh" | xargs dos2unix >/dev/null 2>&1
    cd 8.5.1.SPC100_PATCH
    sh revert.sh
    rm -rf "${CURRENT_PATH}"/8.5.1.SPC100_PATCH
}


case "${karbor_version}" in
    "8.2.0.SPC500")
        rollback_851SPC100_patch
        ;;
    "8.2.0.SPH503")
        rollback_851SPC100_patch
        ;;
    "8.3.0")
        rollback_851SPC100_patch
        ;;
    "8.3.1")
        rollback_851SPC100_patch
        ;;
    "8.5.0")
        rollback_851SPC100_patch
        ;;
    *)
        echo "This patch does not need to be uninstalled in current version, the current version is ${karbor_version}."
        ;;
esac
