#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function check_firewall_status()
{
    if (systemctl status firewalld | grep -w active >/dev/null 2>&1);then
        CHECK_RESULT 1 "firewall is opened,should be close the firewall before install CSBS"
    fi
    log_info "Check firewall status OK."
}

function check_os_version()
{
    hwPlatform=$(uname -i)
    osVersion=$(grep EulerOS /etc/euleros-release | awk '{print $3}')
    if [[ "${hwPlatform}" == "x86_64" && "${osVersion}" == "2.0" ]] || [[ "${hwPlatform}" == "aarch64" && "${osVersion}" == "2.0" ]];then
        log_info "Check required os version OK."
    else
        CHECK_RESULT 1 "Not supported operation system. Only supported Euler 2.0 (x86_64)."
    fi
    log_info "Check required os version OK."
}

function check_dir_exist()
{
    REQ_PHY_DIR=("/" "/opt")
    for dirItem in "${REQ_PHY_DIR[@]}";do
        if ! (df -h | awk '{print $6}' |grep "${dirItem}$");then
            CHECK_RESULT 1 "(${dirItem}) dist don't exist..."
        fi
    done
    return 0
}

function check_free_disk_space()
{
    REQ_PHY_DIR_IN_KB=("/=5242880" "/opt=62914560")
    for chkPair in "${REQ_PHY_DIR_IN_KB[@]}";do
        chkDir=$(echo "${chkPair}" | cut -d '=' -f 1)
        requiredSpace=$(echo "${chkPair}" | cut -d '=' -f 2)
        freeSpace=$(df -k "${chkDir}" | tail -n -1 | awk '{print $4}')
        if (df | grep "${chkDir}$");then
            if [[ "${freeSpace}" -lt "${requiredSpace}" ]];then
                log_warn "Current free disk space (${freeSpace}KB) for \"${chkDir}\" is insufficient. It should not be less than ${requiredSpace}KB."
            fi
        else
            CHECK_RESULT 1 "($chkDir) dist don't exist..."
        fi
    done
    log_info "Check required free disk space OK."
}

function check_cpu_count()
{
    REQ_CPU_CORE_NUM=4 #4U
    cpuCnt=$(grep -c processor /proc/cpuinfo)
    if [[ "${cpuCnt}" -lt "${REQ_CPU_CORE_NUM}" ]];then
        CHECK_RESULT 1 "The number of processors should not less than ${REQ_CPU_CORE_NUM}."
    fi
    log_info "Check required cpu count OK."
}

function check_memory()
{
    REQ_PHY_MEM_IN_KB=7340032 #8G
    totalMem=$(grep MemTotal /proc/meminfo | awk '{print $2}')
    if [[ "${totalMem}" -lt "${REQ_PHY_MEM_IN_KB}" ]];then
        CHECK_RESULT 1 "System total memory (${totalMem}KB) should not less than ${REQ_PHY_MEM_IN_KB}KB."
    fi
    log_info "Check required system memory OK."
}

function check_umask()
{
    umask_val=$(umask)
    if [[ ${umask_val} -gt '0077' ]];then
        CHECK_RESULT 1 "umask val(${umask_val}) not meet the requirement:0077."
    fi
    log_info "Successfully checked umask."
}

check_firewall_status
check_os_version
check_dir_exist
check_free_disk_space
check_cpu_count
check_memory
check_umask
exit 0







