#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

# ================================= install ====================================
function install()
{
    log_info "Start to config OS."
    bash "${CURRENT_PATH}/allocate_disk.sh"
    CHECK_RESULT $? "Allocate disk failed."

    # stop and disable firewall
    systemctl stop firewalld
    systemctl disable firewalld.service

    # enable iptables and ntpd
    echo "" > /etc/sysconfig/iptables
    systemctl restart iptables
    systemctl enable iptables
    systemctl enable ntpd.service

    #stop rpcbind
    service rpcbind stop
    systemctl disable  rpcbind

    # stop rpcbind.socket
    systemctl stop rpcbind.socket
    systemctl disable rpcbind.socket

    log_info "Config OS successfully."
}

# ================================= check ======================================
function check()
{
    # to do
    exit 0
}

# ================================= rollback ===================================
function rollback()
{
    # to do
    exit 0
}

# ================================= main =======================================
main()
{
    if [[ $# -lt 1 ]]; then
        CHECK_RESULT 1 "Parameter error. Usage: bash os_config.sh [install|check|rollback] <public|private>."
    fi

    case "$1" in
        install)
            install
        ;;
        check)
            check
        ;;
        rollback)
            rollback
        ;;
        *)
            CHECK_RESULT 1 "Parameter error. Usage: bash os_config.sh [install|check|rollback] <public|private>."
        ;;
    esac
}

main "$@"
exit 0