#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

# 修改ssh相关配置
function modify_etc_ssh_sshd_config()
{
    sed -i "/UsePrivilegeSeparation/d" /etc/ssh/sshd_config
    sed -i "/PasswordAuthentication/d" /etc/ssh/sshd_config
    sed -i "/ChallengeResponseAuthentication/d" /etc/ssh/sshd_config
    sed -i "/maxstartups/d" /etc/ssh/sshd_config
    sed -i "/MaxSessions/d" /etc/ssh/sshd_config
    sed -i "/PermitRootLogin/d" /etc/ssh/sshd_config
    sed -i "/AllowUsers/d" /etc/ssh/sshd_config
    sed -i "/KbdInteractiveAuthentication/d" /etc/ssh/sshd_config
    {
        echo "UsePrivilegeSeparation yes"
        echo "PasswordAuthentication no"
        echo "ChallengeResponseAuthentication yes"
        echo "maxstartups 10:30:60"
        echo "MaxSessions 10"
        echo "PermitRootLogin no"
        echo "AllowUsers djmanager"
        echo "KbdInteractiveAuthentication yes"
    } >> /etc/ssh/sshd_config
    service sshd restart > /dev/null 2>&1
}

# 修改db管理员密码为随机
function set_random_db_role_password()
{
    # 避免密码中出现难以处理的 '}'、'{' 字符，转换为')'、'('
    rand_pwd=$(mkpassword 30)
    rand_pwd=$(get_safe_password "${rand_pwd}")
    admin_user=$(get_info gaussdb_admin_user)
/usr/bin/expect<<-EOF
    set timeout 60
    spawn set_db_role_password
    expect {
        "Please input a new password of ${admin_user}:" {send "${rand_pwd}\r"}
    }
    expect {
        "Please input the password again to confirm:" {send "${rand_pwd}\r"}
    }
    expect {
        "Set password of ${admin_user} Successfully." {exit 0}
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

# SSH连接加固
modify_etc_ssh_sshd_config
log_info "Do not use the root user to login by the SSH."

# IPTABLES 加固
bash /opt/huawei/root_tools/base/modify_iptables_conf.sh
CHECK_RESULT $? "Config iptables failed."

# 强制刷新根密钥
sudo -u openstack bash /opt/huawei/dj/tools/base/kmc_auto_update_master_key.sh
CHECK_RESULT $? "update master key failed."

# DB密码加固
if [[ -f "${LINE_ROOT}/cms.conf" ]];then
    gaussdb_pwd=$(read_ini_file gaussdb_password FEATURE /opt/huawei/dj/cfg/sys.ini)
    sed -i "s/gaussdb_admin_pwd.*/gaussdb_admin_pwd=${gaussdb_pwd}/" /opt/huawei/dj/cfg/sys.ini
    sed -i "/gaussdb_password.*=/d" /opt/huawei/dj/cfg/sys.ini
elif [[ "$(get_db_role)" == "Primary" ]];then
    set_random_db_role_password
    CHECK_RESULT $? "set db role password failed."
    log_info "security harden set db role password successfully."
fi
exit 0