#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_alarm()
{
    log_info "begin alarm Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old alarm"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new alarm"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new alarm"
    log_info "Finish alarm Upgrade action."
}

log_info "begin alarm Upgrade."
upgrade_alarm
touch "${CURRENT_PATH}/alarm_upgrade_finish"
log_info "Upgrade alarm success."