#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_script()
{
    log_info "Init backup uninstall configuration."
    log_agent_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "log_agent*.whl")
    csbs_python -m pip install --no-deps --force-reinstall "${log_agent_whl}"
    CHECK_RESULT $? "pip install log_agent failed."
    log_info "Finish backup uninstall configuration."
}


function install_rsyslog()
{
    log_info "Init backup rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/backup
    log_info "Finish backup rsyslog configuration."
}

function install_tools()
{
    log_info "Init backup tools configuration."
    mkdir -p /opt/huawei/dj/{tools,etc}/backup
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/backup
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/backup/gaussdb_restore_entry.sh
    create_link /opt/huawei/dj/tools/backup/gaussdb_backup_entry.sh
    log_info "Finish backup tools configuration."
}

function install_version()
{
    log_info "Init backup version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/backup.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy backup ver failed."
    log_info "Finish backup version configuration."
}

function install_crontab()
{
    log_info "Init backup crontab configuration."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/crontab_backup.conf" /etc/cron.d/
    CHECK_RESULT $? "Copy crontab_backup failed."
    cmd_retry "service cron restart" 60 5
    CHECK_RESULT $? "Restart cron failed."
    log_info "Finish backup crontab configuration."
}

function install_permission()
{
    log_info "Init backup permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_common_permission /opt/huawei/djbackup
    set_modify_permission /var/log/huawei/dj
    log_info "Finish backup permission configuration."
}

function install_root()
{
    log_info "Init backup root configuration."
    install_sudo_conf "${CURRENT_PATH}/conf/sudo_backup_conf"
    install_root_tools backup "${CURRENT_PATH}/root_sudo/update_crontab_conf.sh"
    log_info "Finish backup root configuration."
}

function install_conf()
{
    log_info "Init backup conf configuration."
    mkdir -p /opt/huawei/dj/etc/backup /opt/huawei/djbackup/db
    CHECK_RESULT $? "Copy backup_files failed."
    log_info "Finish backup conf configuration."
}

log_info "Start backup installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish backup installation."
