#!/bin/bash
FOR_ENCRYPT="$1"

function ssh_host_sm2_key()
{
    /usr/bin/expect<<-EOF
    set timeout 60
    spawn ssh-keygen -t sm2 -m PEM -f /etc/ssh/ssh_host_sm2_key
    expect {
        "*passphrase*" {
            exec sleep 1
            send "\r"
            send "exit $?\r"
            exp_continue
        }
        "*Overwrite*" {
            exec sleep 1
            send "y\r"
            exp_continue
        }
        "*y/n*" {
            exec sleep 1
            send "y\r"
            exp_continue
        }
        "*same passphrase again:*" {
            exec sleep 1
            send "\r"
            exit 0
        }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}


function changeToGeneralCipherR9_R10()
{
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/system-auth
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/password-auth
    sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sm3/crypt_style = sha512/g" /etc/libuser.conf
    sed -i 's/+sm3//g' /etc/aide.conf &>/dev/null
    sed -i s/rsa-sha2-256,sm2/rsa-sha2-256/g /etc/ssh/sshd_config
    sed -i s/aes256-gcm@openssh.com,sm4-ctr/aes256-gcm@openssh.com/g /etc/ssh/sshd_config
    sed -i s/hmac-sha2-256-etm@openssh.com,hmac-sm3/hmac-sha2-256-etm@openssh.com/g /etc/ssh/sshd_config
    sed -i s/diffie-hellman-group-exchange-sha256,sm2-sm3/diffie-hellman-group-exchange-sha256/g /etc/ssh/sshd_config
    sed -i '/FingerprintHash sm3\|ssh_host_sm2_key/d' /etc/ssh/sshd_config
    rm -f /etc/ssh/ssh_host_sm2_key*
    systemctl restart sshd
}


function changeToSMCipherR9_R10()
{
    if grep -q "crypt_style = sm3" /etc/libuser.conf;then
        echo "os already use SM algorithm."
        exit 0
    fi
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/system-auth
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/password-auth
    sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sha512/crypt_style = sm3/g" /etc/libuser.conf
    sed -i '/^FIPSR[[:space:]]*=\|^DATAONLY[[:space:]]*=/ s/$/+sm3/' /etc/aide.conf &>/dev/null
    sed -i s/rsa-sha2-256/rsa-sha2-256,sm2/g /etc/ssh/sshd_config
    sed -i s/aes256-gcm@openssh.com/aes256-gcm@openssh.com,sm4-ctr/g /etc/ssh/sshd_config
    sed -i s/hmac-sha2-256-etm@openssh.com/hmac-sha2-256-etm@openssh.com,hmac-sm3/g /etc/ssh/sshd_config
    sed -i s/diffie-hellman-group-exchange-sha256/diffie-hellman-group-exchange-sha256,sm2-sm3/g /etc/ssh/sshd_config
    echo "FingerprintHash sm3" >> /etc/ssh/sshd_config
    echo "HostKey /etc/ssh/ssh_host_sm2_key" >> /etc/ssh/sshd_config
    ssh_host_sm2_key
    if [ $? != 0 ];then
        exit 1
    else
        systemctl restart sshd
    fi
}


function changeToGeneralCipherR8()
{
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/system-auth
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/password-auth
    sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sm3/crypt_style = sha512/g" /etc/libuser.conf
    sed -i 's/+sm3//g' /etc/aide.conf &>/dev/null
}


function changeToSMCipherR8() {
    if grep -q "crypt_style = sm3" /etc/libuser.conf;then
        echo "os already use SM algorithm."
        exit 0
    fi
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/system-auth
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/password-auth
    sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sha512/crypt_style = sm3/g" /etc/libuser.conf
    sed -i '/^FIPSR[[:space:]]*=\|^DATAONLY[[:space:]]*=/ s/$/+sm3/' /etc/aide.conf &>/dev/null
}


function changeToSMCipherR11()
{
  if grep -q "crypt_style = sm3" /etc/libuser.conf;then
      echo "os already use SM algorithm."
      exit 0
  fi

  sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/system-auth
  sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/password-auth
  sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*yescrypt/crypt_style = sm3/g" /etc/libuser.conf
  sed -i '/^FIPSR[[:space:]]*=\|^DATAONLY[[:space:]]*=/ s/$/+sm3/' /etc/aide.conf &>/dev/null
  sed -i s/rsa-sha2-256/rsa-sha2-256,sm2/g /etc/ssh/sshd_config
  sed -i s/aes256-gcm@openssh.com/aes256-gcm@openssh.com,sm4-ctr/g /etc/ssh/sshd_config
  sed -i s/hmac-sha2-256-etm@openssh.com/hmac-sha2-256-etm@openssh.com,hmac-sm3/g /etc/ssh/sshd_config
  sed -i s/diffie-hellman-group-exchange-sha256/diffie-hellman-group-exchange-sha256,sm2-sm3/g /etc/ssh/sshd_config
  echo "FingerprintHash sm3" >> /etc/ssh/sshd_config
  echo "HostKey /etc/ssh/ssh_host_sm2_key" >> /etc/ssh/sshd_config
  ssh_host_sm2_key
  if [ $? != 0 ];then
      exit 1
  else
      systemctl restart sshd
  fi
}


function changeToGeneralCipherR11()
{
  sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/system-auth
  sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/password-auth
  sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sm3/crypt_style = yescrypt/g" /etc/libuser.conf
  sed -i 's/+sm3//g' /etc/aide.conf &>/dev/null
  sed -i s/rsa-sha2-256,sm2/rsa-sha2-256/g /etc/ssh/sshd_config
  sed -i s/aes256-gcm@openssh.com,sm4-ctr/aes256-gcm@openssh.com/g /etc/ssh/sshd_config
  sed -i s/hmac-sha2-256-etm@openssh.com,hmac-sm3/hmac-sha2-256-etm@openssh.com/g /etc/ssh/sshd_config
  sed -i s/diffie-hellman-group-exchange-sha256,sm2-sm3/diffie-hellman-group-exchange-sha256/g /etc/ssh/sshd_config
  sed -i '/FingerprintHash sm3\|ssh_host_sm2_key/d' /etc/ssh/sshd_config

  rm -f /etc/ssh/ssh_host_sm2_key*
  systemctl restart sshd
}

function changeToGeneralCipher()
{
  if [[ $1 -eq 8 ]]; then
    changeToGeneralCipherR8

  elif [[ $1 -eq 9 ]] || [[ $1 -eq 10 ]]; then
    changeToGeneralCipherR9_R10

  elif [[ $1 -gt 10 ]]; then
    changeToGeneralCipherR11

  else
    exit 1
  fi
}

function changeToSMCipher()
{
  if [[ $1 -eq 8 ]]; then
    changeToSMCipherR8

  elif [[ $1 -eq 9 ]] || [[ $1 -eq 10 ]]; then
    changeToSMCipherR9_R10

  elif [[ $1 -gt 10 ]]; then
    changeToSMCipherR11

  else
    exit 1
  fi
}

function main()
{
    local -r version=$(uname -r | grep -oP 'eulerosv\K(\d+)r(\d+)' | awk -F'r' '{print $2}')

    if [ "$FOR_ENCRYPT" = "generalCipher" ]; then
      changeToGeneralCipher $version
    else
      changeToSMCipher $version
    fi

    echo "config os success"
}

main
