#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo "$(readlink -f "$0")" "$@";exit $?
fi
# 外部输入参数使用前需要校验
[[ $# -ne 0 ]] && exit 1

# 从openstack用户获取集群节点信息使用前需要校验:预期IP格式
source /opt/huawei/root_tools/base/root_utils.sh
IFS="," read -r -a NODE_LIST <<< "MANAGE_IP_LIST"

##### iptables配置前采用-C检查
##### iptables采用-A进行配置，规则将会插入规则链最后一条
##### iptables配置时先配置配置白名单作为例外，然后配置拒绝策略
iptables -F INPUT
iptables -F OUTPUT

##############################################################################
# 配置INPUT白名单
##############################################################################
# 配置iptables INPUT关联策略
if ! (iptables -C INPUT -m state --state ESTABLISHED -j ACCEPT >/dev/null 2>&1);then
    iptables -A INPUT -m state --state ESTABLISHED -j ACCEPT
fi
# 允许其他机器ping通本机地址
if ! (iptables -C INPUT -p icmp --icmp-type echo-request -j ACCEPT  >/dev/null 2>&1);then
    iptables -A INPUT -p icmp --icmp-type echo-request -j ACCEPT
fi
# 允许本地回环输入
if ! (iptables -C INPUT -i lo -j ACCEPT  >/dev/null 2>&1);then
    iptables -A INPUT -i lo -j ACCEPT
fi
# 允许对本机123端口udp访问
if ! (iptables -C INPUT -p udp --dport 123 -j ACCEPT >/dev/null 2>&1);then
    iptables -A INPUT -p udp --dport 123 -j ACCEPT
fi
# 允许对本机22端口tcp访问
if ! (iptables -C INPUT -p tcp --dport 22 -j ACCEPT >/dev/null 2>&1);then
    iptables -A INPUT -p tcp --dport 22 -j ACCEPT
fi
# 允许对本机Karbor端口访问
if ! (iptables -C INPUT -p tcp --dport 8799 -j ACCEPT >/dev/null 2>&1);then
    iptables -A INPUT -p tcp --dport 8799 -j ACCEPT
fi
# 允许对本机MOICAgent端口访问
if ! (iptables -C INPUT -p tcp --dport 26401 -j ACCEPT >/dev/null 2>&1);then
    iptables -A INPUT -p tcp --dport 26401 -j ACCEPT
fi
# 允许集群IP对本机端口访问
for node in "${NODE_LIST[@]}";do
    check_ip "${node}" || exit 2
    if ! (iptables -C INPUT -s "${node}" -j ACCEPT >/dev/null 2>&1);then
        iptables -A INPUT -s "${node}" -j ACCEPT
    fi
done
##############################################################################
# 配置 OUTPUT白名单
##############################################################################
# 允许输出到本地回环
if ! (iptables -C OUTPUT -o lo -j ACCEPT >/dev/null 2>&1);then
    iptables -A OUTPUT -o lo -j ACCEPT
fi
# 配置iptables OUTPUT关联策略
if ! (iptables -C OUTPUT -m state --state NEW,ESTABLISHED -j ACCEPT >/dev/null 2>&1);then
    iptables -A OUTPUT -m state --state NEW,ESTABLISHED -j ACCEPT
fi
##############################################################################
# 配置INPUT拒绝策略
##############################################################################
# 禁止127私网设备
if ! (iptables -C INPUT -s 127.0.0.0/8 -j REJECT >/dev/null 2>&1);then
    iptables -A INPUT -s 127.0.0.0/8 -j REJECT
fi
# 禁止对本机非白名单端口访问
if ! (iptables -C INPUT -j REJECT >/dev/null 2>&1);then
    iptables -A INPUT -j REJECT
fi
##############################################################################
# 配置OUTPUT拒绝策略
##############################################################################
# 禁止本机icmp的类型timestamp-request探测
if ! (iptables -C OUTPUT -p icmp -m icmp --icmp-type timestamp-request -j REJECT >/dev/null 2>&1);then
    iptables -A OUTPUT -p icmp -m icmp --icmp-type timestamp-request -j REJECT
fi
# 禁止本机icmp的类型redirect探测
if ! (iptables -C OUTPUT -p icmp -m icmp --icmp-type redirect -j REJECT >/dev/null 2>&1);then
    iptables -A OUTPUT -p icmp -m icmp --icmp-type redirect -j REJECT
fi
# 禁止本机icmp的类型timestamp-reply探测
if ! (iptables -C OUTPUT -p icmp -m icmp --icmp-type timestamp-reply -j REJECT >/dev/null 2>&1);then
    iptables -A OUTPUT -p icmp -m icmp --icmp-type timestamp-reply -j REJECT
fi
# 禁止本机icmp的类型16探测
if ! (iptables -C OUTPUT -p icmp -m icmp --icmp-type 16 -j REJECT >/dev/null 2>&1);then
    iptables -A OUTPUT -p icmp -m icmp --icmp-type 16 -j REJECT
fi
exit 0