#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="update_kmc_key"
KMC_MK_FILE="/opt/huawei/dj/paas/kmc_master_key"
KEY_ID=0
CURRENT_NODE=$(get_info manage_ip)

function create_mk()
{
    (
        echo "from kmc import kmc"
        echo "try:"
        echo "    print(kmc.API().create_mk(0))"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}
function active_mk()
{
    export CSBS_PYTHON_DATA="${KEY_ID}"
    (
        echo "import os"
        echo "from kmc import kmc"
        echo "try:"
        echo "    key = os.getenv('CSBS_PYTHON_DATA')"
        echo "    exit(int(kmc.API().active_mk(0, key)))"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}
function export_mk_file()
{
    export CSBS_PYTHON_DATA1="${KMC_MK_FILE}"
    export CSBS_PYTHON_DATA2="${KEY_ID}"
    (
        echo "import os"
        echo "from kmc import kmc"
        echo "try:"
        echo "    file = os.getenv('CSBS_PYTHON_DATA1')"
        echo "    key = os.getenv('CSBS_PYTHON_DATA2')"
        echo "    kmc.API().export_mk_file(file, key)"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}
function import_mk_file()
{
    export CSBS_PYTHON_DATA1="${KMC_MK_FILE}"
    export CSBS_PYTHON_DATA2="${KEY_ID}"
    (
        echo "import os"
        echo "from kmc import kmc"
        echo "try:"
        echo "    file = os.getenv('CSBS_PYTHON_DATA1')"
        echo "    key = os.getenv('CSBS_PYTHON_DATA2')"
        echo "    kmc.API().import_mk_file(file, key)"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}
function generate_mk()
{
    KEY_ID=$(create_mk)
    ECHO_RETURN $? "Active KMC master key on ${CURRENT_NODE} failed."
    export_mk_file
    ECHO_RETURN $? "Export KMC master key on ${CURRENT_NODE} failed."
    echo_info "Generate KMC master key on ${CURRENT_NODE} success."
}

function import_master_key()
{
    echo_info "Begin import KMC master key."
    import_mk_file
    ECHO_RETURN $? "Import KMC master key file on ${CURRENT_NODE} failed."
    active_mk
    ECHO_RETURN $? "Active KMC master key file on ${CURRENT_NODE} failed."
    echo_info "Import KMC master key on ${CURRENT_NODE} success."
}


function sync_file()
{
    IFS="," read -r -a node_ip_list <<< "$(get_info manage_ip_list)"
    for node_ip in "${node_ip_list[@]}";do
        if [[ "${CURRENT_NODE}" == "${node_ip}" ]];then
            continue
        fi
        cmd_manager --node_ip "${node_ip}" --cmd "$(readlink -f "$0")" --parameters "import" --parameters "${KEY_ID}" --parameters "${CURRENT_NODE}"
        ECHO_RETURN $? "Import KMC master key on ${CURRENT_NODE} failed."
        echo_info "Sync KMC master key to ${node_ip} success."
    done
    active_mk
    ECHO_RETURN $? "Active KMC master key file on ${CURRENT_NODE} failed."
    echo_info "Update KMC master key on ${CURRENT_NODE} success."
}


if [[ $# -eq 3 ]] && [[ "$1" == 'import' ]];then
    download_file --node_ip "$3" --source_file "${KMC_MK_FILE}" --target_file "${KMC_MK_FILE}" >/dev/null 2>&1
    ECHO_RETURN $? "Download master key from $3 on ${CURRENT_NODE} failed ."
    KEY_ID=$2
    import_master_key
elif [[ $# -eq 0 ]];then
    generate_mk
    sync_file
else
    echo_error "$0 $* not support."
fi