#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="cli-client"

sys_ini="/opt/huawei/dj/cfg/sys.ini"

function change_auth_endpoint() {
    auth_endpoint=$(get_cms_info "$1")
    if [[ -z "${auth_endpoint}" ]];then
        CHECK_RESULT 1 "get auth_endpoint from cms failed."
    fi
    auth_url=$(get_dict_info "${auth_endpoint}" "auth_url")
    if [[ -z "${auth_url}" ]];then
        CHECK_RESULT 1 "get auth_url from cms failed."
    fi
    echo "${auth_url}" | xargs | grep -E "^https://[-a-zA-Z0-9./:]+$">/dev/null
    CHECK_RESULT $? "Incorrect endpoint. Please try again."

    config_auth="auth_url = ${auth_url}"
    line=$(grep -n "\[SYSTEM\]" "${sys_ini}" | cut -d: -f1)
    ret=$(grep "auth_url" "${sys_ini}")
    if [[ -z "${ret}" ]];then
        sed -i "${line}a${config_auth}" "${sys_ini}"
    else
        sed -i "s#auth_url.*#${config_auth}#" "${sys_ini}"
    fi
    log_info "Set auth_url config successfully."
}

function change_cert_verify_switch() {
    karbor_features=$(get_cms_info "$1")
    if [[ -z "${karbor_features}" ]];then
        CHECK_RESULT 1 "Get karbor_features from cms failed."
    fi
    cert_verify_switch=$(get_dict_info "${karbor_features}" "certificate_verification_switch")
    if [[ -z "${cert_verify_switch}" ]];then
        CHECK_RESULT 1 "get cert_verify_switch from cms failed."
    fi
    echo "${cert_verify_switch}" | xargs | grep -E "false|true">/dev/null
    CHECK_RESULT $? "Incorrect cert_verify_switch. Please try again."

    config_switch="certificate_verification_switch = ${cert_verify_switch}"
    line=$(grep -n "\[FEATURE\]" "${sys_ini}" | cut -d: -f1)
    ret=$(grep "certificate_verification_switch" "${sys_ini}")
    if [[ -z "${ret}" ]];then
        sed -i "${line}a${config_switch}" "${sys_ini}"
    else
        sed -i "s#certificate_verification.*#${config_switch}#" "${sys_ini}"
    fi
    log_info "Set cert_verify_switch config successfully."
}

case "$1" in
    "ascagent.common.auth_endpoint")
        change_auth_endpoint "$1"
    ;;
    "karbor.features")
        change_cert_verify_switch "$1"
    ;;
    *)
        CHECK_RESULT 1 "$1 is not cli watcher key."
esac
