#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import configparser
import json
import os
import stat
import sys

from basesdk import utils, cms_info

KEY_AUTO_REPORT = 'report.auto_report'
REPORT_CONF_PATH = "/opt/huawei/dj/etc/karbor/report/report.conf"
log = utils.get_logger("cli-client")


def update_report_conf(report_type):
    log.info(f"Start to update configuration information, report_type:{report_type}.")
    conf_data_str = cms_info.get_cms_info(KEY_AUTO_REPORT)
    if conf_data_str:
        conf_data = json.loads(conf_data_str)
    else:
        raise Exception(f"Failed to obtain config info from the cms, the key:{KEY_AUTO_REPORT}.")
    tar_update_data = conf_data.get(report_type)
    conf = configparser.ConfigParser()
    conf.read(REPORT_CONF_PATH)
    if not conf.has_section(report_type):
        raise Exception(f"The key do not exist, key:{report_type}.")
    for sub_key, value in tar_update_data.items():
        conf.set(report_type, sub_key, str(value))
    flags = os.O_WRONLY | os.O_CREAT | os.O_TRUNC
    modes = stat.S_IWUSR | stat.S_IRUSR
    with os.fdopen(os.open(REPORT_CONF_PATH, flags, modes), 'w') as file:
        conf.write(file)
    log.info("The report configuration file is updated successfully.")


if __name__ == "__main__":
    try:
        if len(sys.argv) != 2:
            raise Exception("Incorrect number of parameters. One parameter is required to call this method.")
        update_report_conf(sys.argv[1])
    except Exception as err:
        log.error(f"Failed to update the report configuration, err_msg:{err}.")
        sys.exit(1)
