#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init cms rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/cms
    log_info "Finish cms rsyslog configuration."
}

function install_script()
{
    log_info "Init cms script configuration."
    cms_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "cms*.whl")
    csbs_python -m pip install --no-deps --force-reinstall  "${cms_whl}"
    CHECK_RESULT $? "pip install cms failed."
    log_info "Finish cms script configuration."
}

function install_tools()
{
    log_info "Init cms tools configuration."
    mkdir -p /opt/huawei/dj/tools/cms
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/cms
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/cms/cmsControl.sh
    log_info "Finish cms tools configuration."
}

function install_version()
{
    log_info "Init cms version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/cms.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy cms version Failed."
    log_info "Finish cms version configuration."
}

function install_permission()
{
    log_info "Init cms permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/etc/cms/cms.conf
    set_modify_permission /var/log/huawei/dj
    log_info "Finish cms permission configuration."
}

function install_root()
{
    log_info "Init cms root configuration."
    log_info "Finish cms root configuration."
}

function install_crontab()
{
    log_info "Init cms crontab configuration."
    log_info "Finish cms crontab configuration."
}

function install_conf()
{
    log_info "Init cms conf configuration."
    log_info "Finish cms conf configuration."
}

log_info "Start cms installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish cms installation."
