#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo "$(readlink -f "$0")" "$@";exit $?
fi
# 外部输入参数使用前需要校验
# 参数为不定个数IP或域名格式参数列表
[[ $# -eq 0 ]] && exit 1

source /opt/huawei/root_tools/base/root_utils.sh
if [[ "$1" == "config_ntp_cert" ]];then
    check_domain_or_ip "$2" || exit 2
    read -rst 60 cert_data
    rm -f "/etc/ntp/ntpkey_RSA-SHA256cert_$2"
    echo "${cert_data}" | base64 -d > "/etc/ntp/ntpkey_RSA-SHA256cert_$2"
    exit 0
elif [[ "$1" == "delete_ntp_cert" ]];then
    check_domain_or_ip "$2" || exit 2
    rm -f "/etc/ntp/ntpkey_RSA-SHA256cert_$2"
    exit 0
fi

for ntp_ip in "$@";do
    check_domain_or_ip "${ntp_ip}" || exit 2
done

sed -i '/^server /d' /etc/ntp.conf
for ntp_ip in "$@";do
    if [[ -f "/etc/ntp/ntpkey_RSA-SHA256cert_${ntp_ip}" ]];then
        sed -i "\$aserver ${ntp_ip} autokey" /etc/ntp.conf
    else
        sed -i "\$aserver ${ntp_ip}" /etc/ntp.conf
    fi
done
systemctl restart ntpd.service