#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init digital_certificate rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/digital_certificate
    log_info "Finish digital_certificate rsyslog configuration."
}

function install_tools()
{
    log_info "Init digital_certificate tools configuration."
    mkdir -p /opt/huawei/dj/tools/digital_certificate
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/digital_certificate
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    log_info "Finish digital_certificate tools configuration."
}

function install_version()
{
    log_info "Init digital_certificate version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/digital_certificate.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy digital_certificate version Failed."
    log_info "Finish digital_certificate version configuration."
}

function install_permission()
{
    log_info "Init digital_certificate permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/DJSecurity
    set_modify_permission /var/log/huawei/dj
    log_info "Finish digital_certificate permission configuration."
}

function install_conf()
{
    log_info "Init digital_certificate conf configuration."
    log_info "Finish digital_certificate conf configuration."
}

function install_crontab()
{
    log_info "Init digital_certificate crontab configuration."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/crontab_digital_certificate.conf" /etc/cron.d/
    CHECK_RESULT $? "Copy crontab_digital_certificate failed."
    cmd_retry "service cron restart" 60 5
    CHECK_RESULT $? "Restart cron failed."
    log_info "Finish digital_certificate crontab configuration."
}

function install_root()
{
    log_info "Init digital_certificate root configuration."
    log_info "Finish digital_certificate root configuration."
}

function install_script()
{
    log_info "Init digital_certificate script configuration."
    log_info "Finish digital_certificate script configuration."
}

log_info "Start digital_certificate installation."
install_rsyslog
install_script
install_root
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish digital_certificate installation."
