#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo "$(readlink -f "$0")" "$@";exit $?
fi
# 外部输入参数使用前需要校验
# 参数1为数字，大于0小于32
[[ $# -ne 1 ]] && exit 1
schedule_interval=$1

[[ "${schedule_interval}" =~ ^[[:digit:]]*$ ]] || exit 2
[[ "${schedule_interval}" -gt 0 ]] && [[ "${schedule_interval}" -lt 32 ]] || exit 3

TOOL="/opt/huawei/dj/tools/karbor/inspect_long_running_baks.sh"
sed -i "\%${TOOL}%d" /etc/cron.d/crontab_karbor.conf
echo "0 12 */${schedule_interval} * * openstack /bin/bash ${TOOL}" >> /etc/cron.d/crontab_karbor.conf
service cron restart