#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function wait_start()
{
    count=300
    cluster_first_node=$(get_info cluster_first_node)
    while [[ "${count}" -gt 0 ]];do
        if curl -i -k "https://${cluster_first_node}:28799" >/dev/null 2>&1;then
            log_info "Wait cluster first node karbor start success."
            return 0
        fi
        count=$((count-1))
        sleep 5s
    done
    CHECK_RESULT 1 "Wait cluster first node karbor start failed"
}

log_info "Start sync karbor sys configuration"
sync_config /opt/huawei/dj/etc/karbor/karbor.conf /opt/huawei/dj/etc/karbor/config.json
CHECK_RESULT $? "sync karbor sys configuration failed"
while read -r watcher_key;do
    kangaroo_conf "${watcher_key}"
    log_info "update kangaroo_conf ${watcher_key} ret_code:$?"
done < /opt/huawei/dj/etc/karbor/key.para
log_info "Success sync karbor sys configuration"


log_info "Start sync karbor db."
if [[ $(get_info node_index) -ne 1 ]];then
    wait_start
else
    bash /opt/huawei/dj/tools/karbor/init_db.sh
    CHECK_RESULT $? "sync db failed."
fi
log_info "End sync karbor db."


log_info "Begin to start karbor."
log_info "Begin to start karbor-api."
cmd_retry "karbor-apiControl -A RESTART" 60 5
CHECK_RESULT "$?" "karbor-apiControl -A RESTART"
log_info "start karbor-api success."

log_info "Begin to start karbor-protection."
cmd_retry "karbor-protectionControl -A RESTART" 60 5
CHECK_RESULT "$?" "karbor-protectionControl -A RESTART"
log_info "start karbor-protection success."

log_info "Begin to start karbor-operation."
cmd_retry "karbor-operationControl -A RESTART" 60 5
CHECK_RESULT "$?" "karbor-operationControl -A RESTART"
log_info "start karbor-operation success."
log_info "End to start karbor."
