#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function stop_service()
{
    karbor-operationControl -S STOP
    karbor-apiControl -S STOP
    karbor-protectionControl -S STOP
    docker stop karboroperation
    docker stop karborprotection
    docker stop karborapi
}

function uninstall_file()
{
    rm -rf /etc/cron.d/crontab_karbor.conf
    rm -rf /etc/sudoers.d/sudo_karbor_conf
    rm -rf /opt/huawei/dj/versions/karbor.ver
    rm -rf /opt/huawei/dj/etc/karbor
    rm -rf /opt/huawei/dj/tools/karbor
    rm -rf /opt/huawei/dj/bin/python/csbs_python/kangaroo*
    rm -rf /opt/huawei/dj/sbin/karbor-operationControl
    rm -rf /opt/huawei/dj/sbin/karbor-apiControl
    rm -rf /opt/huawei/dj/sbin/karbor-protectionControl
    rm -rf /opt/huawei/dj/sbin/kangaroo-api
    rm -rf /opt/huawei/dj/sbin/kangaroo-manage
    rm -rf /opt/huawei/dj/sbin/kangaroo-protection
    rm -rf /opt/huawei/dj/sbin/kangaroo-operation
    rm -rf /opt/huawei/dj/sbin/kangaroo-tools
    rm -rf /opt/huawei/dj/sbin/kangaroo_conf
}

stop_service >/dev/null 2>&1
uninstall_file >/dev/null 2>&1