#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"
IP_VERSION=$(get_info ip_version)

log_info "Start omm-ha adapter."
omm_ha_tar=$(find "${LINE_ROOT}/repo/platform/omm-ha" -maxdepth 1 -type f -name "HA*.tar.gz")
check_tar_file_before_unzip "${omm_ha_tar}"
CHECK_RESULT $? "Check HA*.tar.gz failed."
tar -xzf "${omm_ha_tar}" --no-same-owner -C "${CURRENT_PATH}" >> /dev/null
CHECK_RESULT $? "Unzip omm-ha pkg."
omm_ha_dir=$(find "${CURRENT_PATH}" -type d -name "HA*")
/usr/bin/cp -f "${CURRENT_PATH}/conf/hasync_mod.xml"  "${omm_ha_dir}/software/module/hasync/plugin/conf"
habin_status="${omm_ha_dir}/software/module/hacom/script/functions/status_habin.sh"
habin_start="${omm_ha_dir}/software/module/hacom/script/functions/start_habin.sh"
ha_status="${omm_ha_dir}/software/module/hacom/script/status_ha.sh"
ha_monitor="${omm_ha_dir}/software/module/hamon/script/start_ha_monitor.sh"
ha_conf="${omm_ha_dir}/software/module/hacom/conf/hacom.xml"
sed -i "s:false:true:g" "${ha_conf}"
sed -i '/scriptLog/d' "${habin_status}" "${ha_status}"
sed -i '/LD_LIBRARY_PATH/d' "${ha_status}"
sed -i '/hcpprocess:hcp/d' "${habin_status}" "${habin_start}" "${ha_monitor}"
[[ ${IP_VERSION} != "ipv6" ]] && sed -i "s/::1/127.0.0.1/g" "${ha_conf}"
log_info "Finish omm-ha adapter."
