#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="rabbitmqControl"

function showhelp()
{
    usage="Usage: rabbitmqControl "
    len=${#usage}
    echo "Usage: rabbitmqControl [-S RUN]"
    printf "%-${len}s[-S STOP]\n"
    printf "%-${len}s[-A RESTART]\n"
    printf "%-${len}s[-CS ComponentState]\n"
    printf "%-${len}s[-h]\n"
    exit 1
}

function args_err()
{
    echo -e "rabbitmqControl: illegal option"
    showhelp
    exit 1
}

function get_component_status()
{
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/tools/rabbitmq/rabbitmq_watcher.py)
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "rabbitmq_watcher is not running."
    fi
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/bin/erlang.*rabbit)
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "rabbitmq process is not running."
    fi
    echo_info "rabbitmq process is running."
    exit 0
}

function component_stop()
{
    echo_info "rabbitmqControl:component_stop begin."
    echo_info "Begin to stop rabbitmq...."
    query_watcher=$(pgrep -U 51001 -f /opt/huawei/dj/tools/rabbitmq/rabbitmq_watcher.py)
    query_rabbitmq=$(pgrep -U 51001 -f /opt/huawei/dj/bin/erlang)
    if [[ -z "${query_watcher}" ]] && [[ -z "${query_rabbitmq}" ]]; then
        echo_info "$(heartBeat STOP rabbitmq)"
        echo_info "rabbitmq process is not running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        kill_process /opt/huawei/dj/tools/rabbitmq/rabbitmq_watcher.py
        kill_process /opt/huawei/dj/tools/rabbitmq/check_cluster.sh
        kill_process /opt/huawei/dj/bin/erlang
        sleep 5
        query_watcher=$(pgrep -U 51001 -f /opt/huawei/dj/tools/rabbitmq/rabbitmq_watcher.py)
        query_rabbitmq=$(pgrep -U 51001 -f /opt/huawei/dj/bin/erlang)
        if [[ -n "${query_watcher}" ]] || [[ -n "${query_rabbitmq}" ]]; then
            log_warn "rabbitmq process is running when stop, error."
            continue
        fi
        echo_info "$(heartBeat STOP rabbitmq)"
        echo_info "stop rabbitmq successfully."
        echo_info "rabbitmqControl:component_stop end."
        return 0
    done
    echo_error "stop rabbitmq failed."
    exit 1
}

function component_run()
{
    echo_info "rabbitmqControl:component_run begin."
    echo_info "Begin to start rabbitmq...."
    query_watcher=$(pgrep -U 51001 -f /opt/huawei/dj/tools/rabbitmq/rabbitmq_watcher.py)
    if [[ -n "${query_watcher}" ]]; then
        echo_info "$(heartBeat START rabbitmq)"
        echo_info "rabbitmq process is running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        proc_manager --path /opt/huawei/dj/tools/rabbitmq --filename rabbitmq_watcher.py
        sleep 5
        query_watcher=$(pgrep -U 51001 -f /opt/huawei/dj/tools/rabbitmq/rabbitmq_watcher.py)
        if [[ -z "${query_watcher}" ]]; then
            log_warn "rabbitmq process is not running when start, error."
            continue
        fi
        echo_info "$(heartBeat START rabbitmq)"
        echo_info "Start rabbitmq finished."
        echo_info "rabbitmqControl:component_run end"
        return 0
    done
    ECHO_RETURN 1 "Start container rabbitmq failed."
}

function component_restart()
{
    echo_info "restart rabbitmq begin."
    component_stop
    sleep 5
    component_run
    echo_info "restart rabbitmq end."
}

while true; do
    case "$1" in
        -S) Action1=$2;shift 2;;
        -CS) Action2=$2;shift 2;;
        -A) Action3=$2;shift 2;;
        -h) showhelp;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action3}" ]; then
    component_restart
elif [ "RUN" = "${Action1}" ]; then
    component_run
elif [ "STOP" = "${Action1}" ]; then
    component_stop
elif [ "ComponentState" = "${Action2}" ]; then
    get_component_status
else
    args_err
fi
exit 0
