#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function wait_start()
{
    count=300
    cluster_first_node=$(get_info cluster_first_node)
    while [[ "${count}" -gt 0 ]];do
        if curl -i -k "https://${cluster_first_node}:28899" >/dev/null 2>&1;then
            log_info "Wait cluster first node resource_manager start success."
            return 0
        fi
        count=$((count-1))
        sleep 5s
    done
    CHECK_RESULT 1 "Wait cluster first node resource_manager start failed"
}

log_info "Start sync resource_manager sys configuration"
sync_config /opt/huawei/dj/etc/resource_manager/resource_manager.conf /opt/huawei/dj/etc/resource_manager/config.json
CHECK_RESULT $? "sync resource_manager sys configuration failed"
while read -r watcher_key;do
    resource_manager_conf "${watcher_key}"
    log_info "update resource_manager_conf ${watcher_key} ret_code:$?"
done < /opt/huawei/dj/etc/resource_manager/key.para
log_info "Success sync resource_manager sys configuration"


log_info "Start sync resource_manager db."
if [[ $(get_info node_index) -ne 1 ]];then
    wait_start
else
    bash /opt/huawei/dj/tools/resource_manager/init_db.sh
    CHECK_RESULT $? "sync db failed."
fi
log_info "End sync resource_manager db."


log_info "Begin to start resource_manager."
cmd_retry "resource_managerControl -A RESTART" 60 5
CHECK_RESULT "$?" "Exec resource_managerControl -A RESTART failed"
log_info "End to start resource_manager."