#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="scagentControl"


function showhelp()
{
    echo "Usage: scagentControl : -S ServiceState"
    echo "  -S ServiceState (RUN STOP)"
    echo "  -A RESTART"
    echo "  -CS ComponentState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "scagent: illegal option"
    showhelp
    exit 1
}

function component_run()
{
    echo_info "Begin to start scagent...."
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/scagent_server)
    if [[ -n "${queryCmd}" ]]; then
        echo_info "$(heartBeat START scagent)"
        echo_info "scagent process is running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        proc_manager --filename scagent_server
        sleep 5
        queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/scagent_server)
        if [[ -z "${queryCmd}" ]]; then
            log_warn "scagent process is not running when start, error."
            continue
        fi
        echo_info "$(heartBeat START scagent)"
        echo_info "start scagent successfully."
        return 0
    done
    ECHO_RETURN 1 "start scagent failed."
}

function component_stop()
{
    echo_info "Begin to stop scagent...."
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/scagent_server)
    if [[ -z "${queryCmd}" ]]; then
        echo_info "$(heartBeat STOP scagent)"
        echo_info "scagent process is not running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        kill_process /opt/huawei/dj/sbin/scagent_server
        sleep 5
        queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/scagent_server)
        if [[ -n "${queryCmd}" ]]; then
            log_warn "scagent process is running when stop, error."
            continue
        fi
        echo_info "$(heartBeat STOP scagent)"
        echo_info "stop scagent successfully."
        return 0
    done
    ECHO_RETURN 1 "stop scagent failed."
}

function component_restart()
{
    echo_info "scagentControl:component_restart begin"
    component_stop
    sleep 5
    component_run
    echo_info "scagentControl:component_restart end"
}

function component_status()
{
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/scagent_server)
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "scagent process is not running."
    fi
    echo_info "scagent process is running."
    exit 0
}

while true; do
    case "$1" in
        -S) Action1=$2;shift 2;;
        -CS) Action2=$2;shift 2;;
        -A) Action3=$2;shift 2;;
        -h) showhelp;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action3}" ]; then
    component_restart
elif [ "RUN" = "${Action1}" ]; then
    component_run
elif [ "STOP" = "${Action1}" ]; then
    component_stop
elif [ "ComponentState" = "${Action2}" ]; then
    component_status
else
    args_err
fi
exit 0
