#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"


function upgrade_scagent()
{
    log_info "begin scagent Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old scagent"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new scagent"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new scagent"
    log_info "Finish scagent Upgrade action."
}

log_info "begin scagent Upgrade."
upgrade_scagent
touch "${CURRENT_PATH}/scagent_upgrade_finish"
log_info "Upgrade scagent success."