#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="gaussdbRestore"
export PATH=/opt/huawei/dj/bin/gaussdb/app/bin:${PATH}
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
RESTORE_DIR="/opt/huawei/djbackup/db/restore_data"
DB_RESTORE_DIR=""
BACKUP_FILE_NAME=""

function args_err()
{
    echo -e "$0: illegal option"
    ECHO_RETURN 1 "Usage: $0 -f backup_data_file"
}

function prerun()
{
    uncompress_and_check_file
    echo_info "check backup file is ok "
}

function verify_file_hmac()
{
    export CSBS_PYTHON_DATA="$*"
    (
        echo "import os"
        echo "from kmc import kmc"
        echo "try:"
        echo "    file = os.getenv('CSBS_PYTHON_DATA')"
        echo "    exit(kmc.API().verify_file_hmac(0, file))"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}

function uncompress_and_check_file()
{
    rm -rf ${RESTORE_DIR} && mkdir -p ${RESTORE_DIR}
    reasons="Please ensure that file ${BACKUP_FILE_NAME} exists and openstack user has the read permission"
    check_tar_file_before_unzip "${BACKUP_FILE_NAME}"
    ECHO_RETURN $? "Check failed. ${reasons}"
    tar --no-same-owner -xzf "${BACKUP_FILE_NAME}" -C ${RESTORE_DIR}>/dev/null 2>&1
    ECHO_RETURN $? "unzip ${BACKUP_FILE_NAME} failed."
    hmac_file=$(find ${RESTORE_DIR}/backup_file_package -type f -name "*.hmac")
    if ! (verify_file_hmac "${hmac_file}");then
        while [[ 1 -eq 1 ]];do
            echo "The backup file has been changed. Are you sure you want to continue?(Y/N):"
            read -r char
            if [[ "${char}" = "y" || "${char}" = "Y" ]];then
                break
            elif [[ "${char}" = "n" || "${char}" = "N" ]];then
                exit 1
            else
                continue
            fi
        done
    fi
    data_file=$(find ${RESTORE_DIR}/backup_file_package -name "gaussdb_backup*.tar.gz")
    [[ ! -f "${data_file}" ]] && ECHO_RETURN 1 "Can not found gaussdb_backup*.tar.gz"
    check_tar_file_before_unzip "${data_file}"
    ECHO_RETURN $? "Check ${data_file} failed."
    tar --no-same-owner -xzf "${data_file}" -C ${RESTORE_DIR}/backup_file_package>>/dev/null 2>&1
    ECHO_RETURN $? "unzip backupdata ${data_file} failed."
    DB_RESTORE_DIR=$(cd ${RESTORE_DIR}/backup_file_package/gaussdb_backup*/ && pwd)
    gaussdb_version=$(awk 'NR==1' "${DB_RESTORE_DIR}/dj_and_gaussdb_version.json")
    dj_version=$(awk 'NR==2' "${DB_RESTORE_DIR}/dj_and_gaussdb_version.json")
    VERSION_INFO="$(bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh version)"
    DB_VERSION=$(echo "${VERSION_INFO}" | awk -F "(" '{print $2}' | awk -F ")" '{print $1}')
    if [[ "${gaussdb_version}" != "${DB_VERSION}" ]];then
        while [[ 1 -eq 1 ]];do
            echo "Backup GaussDB version [${gaussdb_version}] is inconsistent with Gauss database version [${DB_VERSION}] on the host."
            echo "Are you sure you want to continue?(Y/N):"
            read -r char
            if [[ "${char}" = "y" || "${char}" = "Y" ]];then
                break
            elif [[ "${char}" = "n" || "${char}" = "N" ]];then
                exit 1
            else
                continue
            fi
        done
    fi
    current_dj_version=$(awk 'NR==1' /opt/huawei/dj/cfg/dj.version)
    if [[ "${dj_version}" != "${current_dj_version}" ]];then
        while [[ 1 -eq 1 ]];do
            echo "The backup DJ version[$dj_version] and the host DJ version[$current_dj_version] are not consistent!"
            echo "Are you sure you want to continue?(Y/N):"
            read -r char
            if [[ "${char}" = "y" || "${char}" = "Y" ]];then
                break
            elif [[ "${char}" = "n" || "${char}" = "N" ]];then
                exit 1
            else
                continue
            fi
        done
    fi
}

function digital_certificate_restore()
{
    manage_ip=$(get_info manage_ip)
    IFS="," read -r -a manage_ip_list <<< "$(get_info manage_ip list)"
    /usr/bin/mv -f "${DB_RESTORE_DIR}/digital_certificate.tar.gz" ${RESTORE_DIR}
    ECHO_RETURN $? "Copy digital_certificate failed when start to restore digital_certificate."
    for node in "${manage_ip_list[@]}";do
        if [[ "${manage_ip}" == "${node}" ]];then
            continue
        fi
        cmd_manager --node_ip "${node}" --cmd "${CURRENT_PATH}/gaussdb_restore.sh" --parameters "digital_certificate" --parameters "${manage_ip}"
        ECHO_RETURN $? "Fail restored digital_certificate on node ${node}."
        echo_info "Successfully restored digital_certificate on node ${node}."
    done
    sh "${CURRENT_PATH}/gaussdb_restore.sh" digital_certificate
    ECHO_RETURN $? "Fail restored digital_certificate on node ${manage_ip}."
    echo_info "Successfully restored digital_certificate on node ${manage_ip}."
}

function gaussdb_restore()
{
    /usr/bin/mv -f "${DB_RESTORE_DIR}/rmandatabackup.tar.gz" ${RESTORE_DIR}
    ECHO_RETURN $? "Copy rmandatabackup failed when start to restore gaussdb."
    manage_ip=$(get_info manage_ip)
    primary_node=$(get_primary_db_node)
    echo_info "primary node is ${primary_node}"
    if [[ "${manage_ip}" == "${primary_node}" ]];then
        echo_info "current node ${manage_ip} is the primary."
        sh "${CURRENT_PATH}/gaussdb_restore.sh" rmandatabackup
        ECHO_RETURN $? "Fail restored gaussdb db on current node ${manage_ip}."
        echo_info "Finish restored gaussdb db on current node ${manage_ip}."
    else
        echo_info "DB must be restored on remote node ${primary_node} ..."
        cmd_manager --node_ip "${primary_node}" --cmd "${CURRENT_PATH}/gaussdb_restore.sh" --parameters "rmandatabackup" --parameters "${manage_ip}"
        ECHO_RETURN $? "Fail restored db on remote node ${primary_node}."
        echo_info "Finish restored on on remote node ${primary_node}."
    fi
}

function restore()
{
   while [[ 1 -eq 1 ]];do
        echo "1) restore GaussDB only, 2) restore digital certificate only, 3) restore GaussDB and digital certificate.(1|2|3) "
        read -r char
        if [[ "${char}" = "2" ]];then
            digital_certificate_restore
            return 0
        elif [[ "${char}" = "1" ]];then
            gaussdb_restore
            return 0
        elif [[ "${char}" = "3" ]];then
            digital_certificate_restore
            gaussdb_restore
            return 0
        else
            continue
        fi
    done
}

function postrun()
{
    echo_info "Begin to start all services..."
    IFS="," read -r -a manage_ip_list <<< "$(get_info manage_ip list)"
    manage_ip=$(get_info manage_ip)
    start_tool="/opt/huawei/dj/tools/base/DJserviceControl.sh"
    for node in "${manage_ip_list[@]}";do
        echo_info "start service on ${node}"
        if [[ "${manage_ip}" == "${node}" ]];then
            bash ${start_tool} start
            ECHO_RETURN $? "Fail start service on node ${node}."
            echo_info "Successfully started services on node ${node}."
            continue
        fi
        cmd_manager --node_ip "${node}" --cmd "${start_tool}" --parameters "start"
        ECHO_RETURN $? "Fail start service on node ${node}."
        echo_info "Successfully started services on node ${node}."
    done
    echo_info "Successfully started DJ services."
}

function main()
{
    prerun
    restore
    postrun
}

# 防止并发
if [[ "$(pgrep -U 51001 -f "$0" -d ' ')" != "$$" ]];then
     ECHO_RETURN 1 "The script is running, no need start again."
fi


case "$1 $#" in
    "-f 2")
        BACKUP_FILE_NAME="$2";;
    *)
        args_err;;
esac
main
