#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init cli-client rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/{system,operate}/cli-client
    log_info "Finish cli-client rsyslog configuration."
}

function install_script()
{
    log_info "Init cli-client script configuration."
    cli_client_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "cli_client*.whl")
    csbs_python -m pip install --no-deps --force-reinstall  "${cli_client_whl}"
    CHECK_RESULT $? "pip install cli-client failed."
    install_manager_tools
    log_info "Finish cli-client script configuration."
}

function install_tools()
{
    log_info "Init cli-client tools configuration."
    mkdir -p /opt/huawei/dj/{tools,etc}/cli-client
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/cli-client
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    log_info "Finish cli-client tools configuration."
}

function install_version()
{
    log_info "Init cli-client version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/cli-client.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy cli-client version Failed."
    log_info "Finish cli-client version configuration."
}

function install_permission()
{
    log_info "Init cli-client permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /var/log/huawei/dj
    log_info "Finish cli-client permission configuration."
}

function install_root()
{
    log_info "Init  cli-client root configuration."
    install_sudo_conf "${CURRENT_PATH}/conf/sudo_cli_client_conf"
    install_root_tools cli-client "${CURRENT_PATH}/root_sudo/cmd_manager.sh"
    install_root_tools cli-client "${CURRENT_PATH}/root_sudo/auto_export_report_crontab_conf.sh"
    log_info "Finish  cli-client root configuration."
}

function install_crontab()
{
    log_info "Init cli-client crontab configuration."
    log_info "Finish cli-client crontab configuration."
}

function install_conf()
{
    log_info "Init cli-client conf configuration."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/cmd_manager.conf" /opt/huawei/dj/etc/cli-client
    CHECK_RESULT $? "Install cli-client conf Failed."
    log_info "Finish cli-client conf configuration."
}

log_info "Start cli-client installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish cli-client installation."
