#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi


source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="cps-monitorControl"


function showhelp()
{
    echo "Usage: cps-monitorControl :"
    echo "  -S ServiceState <RUN|STOP>"
    echo "  -A RESTART"
    echo "  -CS ComponentState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "cps-monitorControl: illegal option"
    showhelp
    exit 1
}

function start_cps_monitor()
{
    echo_info "Begin to Start cps_monitor...."
    querysysCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/proc_manager.*cps_monitor")
    if [[ -n "${querysysCmd}" ]]; then
        echo_info "$(heartBeat START cps-monitor)"
        echo_info "cps-monitor process is running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        proc_manager --filename cps_monitor --keepalive 1
        sleep 5
        querysysCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/proc_manager.*cps_monitor")
        if [[ -z "${querysysCmd}" ]]; then
            log_warn "cps-monitor process is not running when start, error."
            continue
        fi
        echo_info "$(heartBeat START cps-monitor)"
        echo_info "Start cps-monitor successfully."
        return 0
    done
    ECHO_RETURN 1 "Start cps-monitor failed."
}

function stop_cps_monitor()
{
    echo_info "Begin to stop cps_monitor...."
    querycpsCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/cps_monitor")
    querysysCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/proc_manager.*cps_monitor")
    if [[ -z "${queryCmd}" ]] && [[ -z "${querysysCmd}" ]]; then
        echo_info "$(heartBeat STOP cps-monitor)"
        echo_info "cps-monitor process is not running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        kill_process "/opt/huawei/dj/sbin/proc_manager.*cps_monitor"
        kill_process "/opt/huawei/dj/sbin/cps_monitor"
        sleep 5
        querycpsCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/cps_monitor")
        querysysCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/proc_manager.*cps_monitor")
        if [[ -n "${querycpsCmd}" ]] || [[ -n "${querysysCmd}" ]]; then
            log_warn "cps-monitor process is running when stop, error."
            continue
        fi
        echo_info "$(heartBeat STOP cps-monitor)"
        echo_info "stop cps-monitor successfully."
        return 0
    done
    echo_error "stop cps-monitor failed."
    exit 1
}


function component_status()
{
    queryCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/proc_manager.*cps_monitor")
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "cps_monitor process is not running."
    fi
    queryCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/cps_monitor")
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "cps_monitor process is not running."
    fi
    echo_info "cps-monitor is running"
    exit 0
}

while true; do
    case "$1" in
        -S) Action1=$2;shift 2;break;;
        -A) Action2=$2;shift 2;break;;
       -CS) Action3=$2;shift 2;break;;
        -h) showhelp;break;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action2}" ]; then
    stop_cps_monitor
    start_cps_monitor
elif [ "RUN" = "${Action1}" ]; then
    start_cps_monitor
elif [ "STOP" = "${Action1}" ]; then
    stop_cps_monitor
elif [ "ComponentState" = "${Action3}" ]; then
    component_status
else
    args_err
fi
exit 0
