#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="log_monitor"
if [[ ! -f "$1" ]] || [[ "$(realpath "$1")" != "$1" ]];then
   CHECK_RESULT 1 "Log($1) cannot be archive."
fi
if [[ -n "${2//[0-9]/}" ]] || [[ "$2" -lt 1 ]] ;then
   CHECK_RESULT 2 "Log($1) retain($2) must more than 0."
fi
/usr/bin/rm -f "$1.$2.gz"
for ((i=$(($2-1));i>=1;i--)); do
   [[ ! -f "$1.${i}.gz" ]] && continue
   /usr/bin/mv -f "$1.${i}.gz" "$1.$((i+1)).gz"
done
gzip -S ".1.gz" -f -q -9 -k "$1" && echo > "$1"
CHECK_RESULT "$?" "gzip $1 failed."
chmod u-w "$1.1.gz"
