#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
G_SYNC_CONF_FILE="/opt/huawei/dj/etc/gaussdb/db_sync.conf"
CURRENT_FILE=$(readlink -f "$0")
#******************************************************************#
# Function: check_sync_progress
# Description: check the progress of db from Active to Standby
# Input Parameters: None
# None
# Return :
#         0  sucess  
#******************************************************************#
function check_sync_progress()
{
    L_SYNC_TIME=$(date "+%s")
    sed -i "s/last_sync_time.*/last_sync_time=${L_SYNC_TIME} /g" ${G_SYNC_CONF_FILE}
    L_DB_INFO="$(bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh query)"
    L_SYNC_PROGRESS=$(echo "${L_DB_INFO} " |grep "sync_percent"|cut -d':' -f2|sed 's/ //g'|sed 's/%//g')
    L_DB_ROLE=$(echo "${L_DB_INFO} " |grep "local_role"|sed -n '1p' | cut -d':' -f2|sed 's/ //g'|sed 's/%//g')
    L_DB_PEER_ROLE=$(echo "${L_DB_INFO} " |grep "peer_role"|sed -n '1p' | cut -d':' -f2|sed 's/ //g'|sed 's/%//g')
    if [ "X${L_DB_ROLE}" == "XStandby" ] && [ "X${L_DB_PEER_ROLE}" != "XPrimary"  ];then
          return 1    
    fi
    if [[ -n "${L_SYNC_PROGRESS}" ]];then
        L_SYNC_PROGRESS=$(echo "${L_SYNC_PROGRESS} " | sed -n '1p')
        L_SYNC_PROGRESS_ALLOW=$(grep "allow_sync_progress" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
        [[ ${L_SYNC_PROGRESS_ALLOW} -lt 90 ]] && L_SYNC_PROGRESS_ALLOW=90
        [[ ${L_SYNC_PROGRESS_ALLOW} -gt 100 ]] && L_SYNC_PROGRESS_ALLOW=100

        if [ "${L_SYNC_PROGRESS}" -gt ${L_SYNC_PROGRESS_ALLOW} ];then
            sed -i "s/^sync_progress=.*/sync_progress=${L_SYNC_PROGRESS} /g" ${G_SYNC_CONF_FILE}
            sed -i "s/^sync_time=.*/sync_time=${L_SYNC_TIME} /g" ${G_SYNC_CONF_FILE}
        fi
        sed -i "s/^db_role=.*/db_role=${L_DB_ROLE} /g" ${G_SYNC_CONF_FILE}
    elif [[ "${L_DB_ROLE}" == "Primary" ]];then
        sed -i "s/^db_role=.*/db_role=${L_DB_ROLE} /g" ${G_SYNC_CONF_FILE}
    fi
    db_role=("Primary" "Standby" "Normal")
    if [[ "${db_role[*]}" =~ ${L_DB_ROLE} ]];then
        sed -i "s/^db_online_time=.*/db_online_time=${L_SYNC_TIME} /g" ${G_SYNC_CONF_FILE}
    fi
    [[ -z "${L_SYNC_PROGRESS}" ]] && L_SYNC_PROGRESS=0
    sed -i "s/last_sync_progress.*/last_sync_progress=${L_SYNC_PROGRESS} /g" ${G_SYNC_CONF_FILE}
    return 0
}


#******************************************************************#
# Function: check_sync_status
# Description: check the sync status of db from Active to Standby
# Input Parameters: None
# None
# Return :
#         0  sucess  
#         1  Sync progress is less then allow
#         2  Sync time is great then allow
#******************************************************************#
function check_sync_status()
{
    L_DB_ONLINE_TIME=$(grep "db_online_time" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    L_CUR_TIME=$(date "+%s")
    L_TIME=$((L_CUR_TIME-L_DB_ONLINE_TIME))
    L_SYNC_TIME_ALLOW=$(grep "allow_sync_time" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    [[ ${L_SYNC_TIME_ALLOW} -lt 1 ]] && L_SYNC_TIME_ALLOW=1
    [[ ${L_SYNC_TIME_ALLOW} -gt 600 ]] && L_SYNC_TIME_ALLOW=600
    L_SYNC_TIME_ALLOW=$((L_SYNC_TIME_ALLOW*60))

    L_SYNC_PROGRESS_ALLOW=$(grep "allow_sync_progress" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    [[ ${L_SYNC_PROGRESS_ALLOW} -lt 90 ]] && L_SYNC_PROGRESS_ALLOW=90
    [[ ${L_SYNC_PROGRESS_ALLOW} -gt 100 ]] && L_SYNC_PROGRESS_ALLOW=100
    L_SYNC_PROGRESS=$(grep "^sync_progress" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    L_SYNC_TIME=$(grep "^sync_time" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    L_SYNC_TIME=$((L_CUR_TIME-L_SYNC_TIME))

    L_DB_ROLE=$(grep "db_role" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    if [[ "${L_DB_ROLE} " =~ ^(Primary|Normal)$ && ${L_SYNC_TIME_ALLOW} -gt $L_TIME ]];then
        if [ ${L_SYNC_TIME}  -gt "${L_SYNC_TIME_ALLOW}" ];then
            echo "Sync time is great then allow"
            return 2
        fi
        echo "${L_DB_ROLE} and time is less then ${L_SYNC_TIME_ALLOW} is ok."
        return 0
    fi

    if [ ${L_SYNC_PROGRESS_ALLOW} -gt "${L_SYNC_PROGRESS}" ];then
        echo "Sync progress is less then allow"
        return 1
    fi

    if [ ${L_SYNC_TIME}  -gt "${L_SYNC_TIME_ALLOW}" ];then
        echo "Sync time is great then allow"
        return 1
    fi

    echo "Sync check success"
    return 0 
}

#******************************************************************#
# Function: reset_sync_progress
# Description: reset the sync process of db from Active to Standby
# Input Parameters: None
# None
# Return :
#         0  sucess  
#******************************************************************#
function reset_sync_progress()
{
    L_SYNC_TIME=$(date "+%s")
    L_SYNC_PROGRESS=100
    L_DB_ROLE=$(grep "db_role" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    sed -i "s/^sync_progress=.*/sync_progress=${L_SYNC_PROGRESS} /g" ${G_SYNC_CONF_FILE}
    sed -i "s/^sync_time=.*/sync_time=${L_SYNC_TIME} /g" ${G_SYNC_CONF_FILE}
    sed -i "s/^db_role=.*/db_role=${L_DB_ROLE} /g" ${G_SYNC_CONF_FILE}
    return 0
}


#******************************************************************#
# Function: get_sync_status
# Description: get the sync status of db from Active to Standby
# Input Parameters: None
# None
# Return :
#         0  sucess  
#******************************************************************#
function get_sync_status()
{
    L_DB_ROLE=$(grep "db_role" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    L_DB_ONLINE_TIME=$(grep "db_online_time" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    echo "DB last online role : ${L_DB_ROLE} "
    echo "DB last online time : $(date -d @"${L_DB_ONLINE_TIME}" '+%Y-%m-%d %H:%M:%S')"
    return 0
}

function backup_file()
{
    if [ -s ${G_SYNC_CONF_FILE} ];then
        /usr/bin/cp -f ${G_SYNC_CONF_FILE}  ${G_SYNC_CONF_FILE}_bk
    fi
    
}

function need_repair_file()
{
    if [ ! -s ${G_SYNC_CONF_FILE} ] && [[ -s ${G_SYNC_CONF_FILE}_bk ]];then
        /usr/bin/cp -f  ${G_SYNC_CONF_FILE}_bk  ${G_SYNC_CONF_FILE}
        return
    fi
}

# 在条件允许的情况下重置主备状态
function safe_reset_status()
{
    if check_sync_status;then
        # 当前允许自动升主，无需重置状态
        return 0
    fi
    L_DB_ONLINE_TIME=$(grep "db_online_time" ${G_SYNC_CONF_FILE}|cut -d'=' -f2)
    peer_node=$(get_info db_peer_node)
    peer_node_last_time=$(cmd_manager --node_ip "${peer_node}" --cmd "${CURRENT_FILE}" --parameters "get_status" | grep "DB last online time")
    [[ -z "${peer_node_last_time}" ]] && return 1
    P_DB_ONLINE_TIME=$(date -d "${peer_node_last_time#*:}" "+%s")
    if [[ ${L_DB_ONLINE_TIME} == "" ]] || [[ ${P_DB_ONLINE_TIME} == "" ]] || [[ ${P_DB_ONLINE_TIME} -gt ${L_DB_ONLINE_TIME} ]];then
        # 本端/对端最后在线时间未获取到，或者本端在线时间比对端在线时间短
        return 1
    fi
    reset_sync_progress
    clear_alarm_from_oc
}

retVal=0
case $1 in
    check_progress)
        backup_file
        check_sync_progress;retVal=$?
        need_repair_file
        ;;
    check_status)
        check_sync_status;retVal=$?
        ;;
    reset_status)
        reset_sync_progress;retVal=$?
        ;;
    get_status)
        get_sync_status;retVal=$?
        ;;
    safe_reset_status)
        safe_reset_status;retVal=$?
        ;;
    *)
        retVal=1
        echo "Invalid operation."
        ;;
esac

exit ${retVal}
