#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"
DB_PWD=$(awk '{print $NF}' /opt/huawei/dj/DJSecurity/privkey/privkey.conf)

[[ -f "${LINE_ROOT}/cms.conf" ]] && exit 0
cmd_retry test_gaussdb_connect 120 10
CHECK_RESULT $? "Gauss db is not normal"
log_info "Gauss db is normal"

log_info "Start create haproxy_a user"
create_user_in_role "haproxy_a" "${DB_PWD}"
CHECK_RESULT $?  "Create db user haproxy_a failed"
log_info "Success create haproxy_a user"

log_info "Start to register role and password to cms"
data="{\"haproxy_db_user\":\"haproxy_a\",\"haproxy_db_pass\":\"${DB_PWD}\"}"
put_cms_info "haproxy.db_user_pass" "${data}"
CHECK_RESULT $? "Save haproxy db user to cms failed"
log_info "Success to save user and password to cms"

log_info "Start creat haproxy_b user"
create_user_in_role "haproxy_b" "${DB_PWD}"
CHECK_RESULT $? "Create db user haproxy_b failed"
log_info "Success create haproxy_b user"

log_info "Start create haproxy database"
create_db_for_owner "haproxy"
CHECK_RESULT $? "Create db haproxy failed"
log_info "Success create haproxy database"