#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="haproxyrun"

function showhelp()
{
    echo "Usage: haproxyControl :"
    echo "  -S ServiceState <RUN|STOP|CHANGE>"
    echo "  -A RESTART"
    echo "  -CS ComponentState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "haproxyControl: illegal option"
    showhelp
    exit 1
}

function component_run()
{
    echo_info "Begin to start haproxy...."
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/haproxy_watcher)
    if [[ -n "${queryCmd}" ]]; then
        echo_info "$(heartBeat START haproxy)"
        echo_info "haproxy process is running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        proc_manager --filename haproxy_watcher
        sleep 10
        queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/haproxy_watcher)
        if [[ -z "${queryCmd}" ]]; then
            log_warn "haproxy process is not running when start, error."
            continue
        fi
        echo_info "$(heartBeat START haproxy)"
        echo_info "start haproxy successfully."
        return 0
    done
    ECHO_RETURN 1 "start haproxy failed."
}

function component_stop()
{
    echo_info "Begin to stop haproxy...."
    query_watcher_Cmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/haproxy_watcher)
    query_exec_Cmd=$(pgrep -U 51001 -f /opt/huawei/dj/bin/haproxy/haproxy)
    if [[ -z "${query_watcher_Cmd}" ]] && [[ -z "${query_exec_Cmd}" ]]; then
        echo_info "$(heartBeat STOP haproxy)"
        echo_info "haproxy process is not running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        kill_process /opt/huawei/dj/sbin/haproxy_watcher
        kill_process /opt/huawei/dj/bin/haproxy/haproxy
        sleep 5
        query_watcher_Cmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/haproxy_watcher)
        query_exec_Cmd=$(pgrep -U 51001 -f /opt/huawei/dj/bin/haproxy/haproxy)
        if [[ -n "${query_watcher_Cmd}" ]] || [[ -n "${query_exec_Cmd}" ]]; then
            log_warn "haproxy process is running when stop, error."
            continue
        fi
        echo_info "$(heartBeat STOP haproxy)"
        echo_info "stop haproxy successfully."
        return 0
    done
    ECHO_RETURN 1 "stop haproxy failed."
}

function component_restart()
{
    echo_info "haproxyControl:component_restart begin"
    component_stop
    component_run
    echo_info "haproxyControl:component_restart end"
}

function checkRun()
{
    query_watcher_Cmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/haproxy_watcher)
    if [[ -z "${query_watcher_Cmd}" ]]; then
        ECHO_RETURN 1 "haproxy_watcher process is not running."
    fi
    query_exec_Cmd=$(pgrep -U 51001 -f /opt/huawei/dj/bin/haproxy/haproxy)
    if [[ -z "${query_exec_Cmd}" ]]; then
        ECHO_RETURN 1 "haproxy process is not running."
    fi
    echo_info "haproxy process is running."
    exit 0
}

while true; do
    case "$1" in
        -S) Action1=$2;shift 2;break;;
        -CS) Action2=$2;shift 2;break;;
        -A) Action3=$2;shift 2;break;;
        -h) showhelp;break;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action3}" ]; then
    component_restart
elif [ "RUN" = "${Action1}" ]; then
    component_run
elif [ "STOP" = "${Action1}" ]; then
    component_stop
elif [ "ComponentState" = "${Action2}" ];then
    checkRun
else
    args_err
fi
exit 0
