#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_version()
{
    log_info "Init inspect version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/inspect.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy inspect version Failed."
    log_info "Finish inspect version configuration."
}

function install_script()
{
    log_info "Init inspect script configuration."
    mkdir -p /opt/huawei/djcollect
    log_info "Finish inspect script configuration."
}


function install_tools()
{
    log_info "Init inspect tools configuration."
    mkdir -p /opt/huawei/dj/tools/inspect
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/inspect
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/inspect/showsys.sh
    ln -sf /opt/huawei/dj/tools/inspect/showsys.sh /usr/bin/showsys
    log_info "Finish inspect tools configuration."
}

function install_conf()
{
    log_info "Init inspect conf configuration."
    log_info "Finish inspect conf configuration."
}

function install_permission()
{
    log_info "Init inspect permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /opt/huawei/djcollect
    set_common_permission /var/log/huawei/dj
    set_modify_permission /var/log/huawei/dj
    log_info "Finish inspect permission configuration."
}

function install_root()
{
    log_info "Init inspect root configuration."
    log_info "Finish inspect root configuration."
}

function install_crontab()
{
    log_info "Init inspect crontab configuration."
    log_info "Finish inspect crontab configuration."
}

function install_rsyslog()
{
    log_info "Init inspect rsyslog configuration."
    log_info "Finish inspect rsyslog configuration."
}

log_info "Start inspect installation."
install_rsyslog
install_script
install_root
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish inspect installation."
