#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
LOCAL_NODE=$(get_info manage_ip)
IFS="," read -r -a NODE_LIST <<< "$(get_info manage_ip_list)"
# **************************************************************************** #
# Function Name: prepare_collect
# Description: 收集前准备
# Parameter:
# Return:
# **************************************************************************** #
function prepare_collect()
{
    rm -rf /opt/huawei/djcollect && mkdir -p /opt/huawei/djcollect
    usage=$(df /opt |grep '/' |awk '{print $5}' |cut -d '%' -f 1)
    if [[ -n "${usage}" ]] && [[ ${usage} -ge 80 ]];then
        echo "ERROR:node:${LOCAL_NODE} space used ${usage} is more than 80%."
        exit 1
    fi
    #check disk opt space to store file;need more than 1G
    requiredSpace_opt=1024000 #1000*1024 K
    space_size_opt=$(df -k /opt/huawei/djcollect |tail -n 1|awk '{print $4}')
    if [[ -z "${space_size_opt}" ]] || [[ ${space_size_opt} -le ${requiredSpace_opt} ]];then
        echo "ERROR:node:${LOCAL_NODE} space ${space_size_opt} is not enough to store log."
        exit 1
    fi
    exit 0
}
# **************************************************************************** #
# Function Name: prepare_collect
# Description: 收集系统信息和集群信息
# Parameter:
# Return:
# **************************************************************************** #
function collect_sys_info()
{
    {
        echo "================================= System Info ================================="
        echo "CPU"
        top -n 1 -b | grep 'Cpu'
        echo "-------------------------------------------------------------------------------"
        echo "Memory"
        top -n 1 -b | grep 'Mem'
        echo "-------------------------------------------------------------------------------"
        echo "Log Space"
        df -h /var/log
        echo "-------------------------------------------------------------------------------"
        echo "System boot"
        date -d "$(awk -F. '{print $1}' /proc/uptime) second ago" +"%Y-%m-%d %H:%M:%S"
        echo "-------------------------------------------------------------------------------"
        echo "iptables"
        iptables -nvL
        echo "-------------------------------------------------------------------------------"
    } >> /opt/huawei/djcollect/sys_info.txt
    {
        echo "================================= Cluster Info ================================="
        echo "DJ cluster info:"
        echo "This node name:"
        hostname
        echo "internal_ip list:"
        get_info manage_ip list
        echo "node count:(\"y\" is online,\"n\" is not online)"
        for node in "${NODE_LIST[@]}";do
            if [[ "$(get_info ip_version)" == "ipv6" ]];then
                my_number=$(ping6 "${node}" -i 0.1 -c 5 |grep -c "64 bytes from")
            else
                my_number=$(ping "${node}" -i 0.1 -c 5 |grep -c "64 bytes from")
            fi
            if [[ ${my_number} -eq 5 ]];then
                echo "${node}:y"
            else
                echo "${node}:n"
            fi
        done
        echo "==============================================================================="
    } >> /opt/huawei/djcollect/cluster_info.txt
}
# **************************************************************************** #
# Function Name: prepare_collect
# Description: 收集版本信息
# Parameter:
# Return:
# **************************************************************************** #
function collect_version_info()
{
    {
        echo "================================= Version Info ================================="
        showsys
        echo "================================================================================"
    } >> /opt/huawei/djcollect/sys_info.txt
}
# **************************************************************************** #
# Function Name: prepare_collect
# Description: 收集日志信息
# Parameter:
# Return:
# **************************************************************************** #
function collect_components_log()
{
    system_dir="/var/log/huawei/dj/services/system/$2"
    operation_dir="/var/log/huawei/dj/services/operate/$2"
    tar -czf "/opt/huawei/djcollect/$1.tar.gz" "${system_dir}" "${operation_dir}"
    return 0
}
# **************************************************************************** #
# Function Name: finish_collect
# Description: 对收集信息进行打包，完成收集
# Parameter:
# Return:
# **************************************************************************** #
function finish_collect()
{
    cd /opt/huawei/djcollect && tar -czf DataCollect.tar.gz ./* --remove-files >/dev/null 2>&1
    exit 0
}

Control_id=$1
case ${Control_id} in
    00)
        prepare_collect
    ;;
    10)
        collect_sys_info
    ;;
    11)
        collect_version_info
    ;;
    20)
        collect_components_log "cps-monitor"
    ;;
    23)
        collect_components_log "zookeeper"
    ;;
    24)
        collect_components_log "gaussdb"
    ;;
    25)
        collect_components_log "haproxy"
    ;;
    26)
        collect_components_log "rabbitmq"
    ;;
    28)
        collect_components_log "karbor"
    ;;
    210)
        collect_components_log "scagent"
    ;;
    211)
        collect_components_log "cms"
    ;;
    212)
        collect_components_log "digital_certificate"
    ;;
    213)
        collect_components_log "kmc"
    ;;
    214)
        collect_components_log "ha"
    ;;
    215)
        collect_components_log "alarm"
    ;;
    216)
        collect_components_log "cli-client"
    ;;
    218)
        collect_components_log "resource_manager"
    ;;
    finish)
        finish_collect
    ;;
    *)
        echo "ERROR:no command find for $*."
        exit 0
esac
exit $?
