#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"
MANAGE_IP=$(get_info manage_ip)
HOST_NAME=$(get_info hostname)
IFS="," read -r -a MQ_NODES <<< "$(get_info rabbitmq_nodes)"

function get_host_list()
{
    for node in "${MQ_NODES[@]}";do
        node_name=$(get_info "${node}")
        if [[ -z "${host_list}" ]];then
            host_list="rabbit@${node_name}"
        else
            host_list="${host_list},rabbit@${node_name}"
        fi
        sed -i "/${node}.*${node_name}/d" /etc/hosts
        echo "${node} ${node_name}" >> /etc/hosts
    done
    echo "${host_list}"
}

sed -i "s/tcp_listeners/ssl_listeners/g" /opt/huawei/dj/bin/rabbitmq/sbin/rabbitmq-server
CHECK_RESULT $? "Because of rabbitmq-server file not exist, config failed."
sed -i "s/127.0.0.1/${MANAGE_IP}/g" /opt/huawei/dj/etc/rabbitmq/rabbitmq-env.conf
sed -i "s/localhost/${HOST_NAME}/g" /opt/huawei/dj/etc/rabbitmq/rabbitmq-env.conf
CHECK_RESULT $? "Because of rabbitmq-env.conf file not exist, config failed."
sed -i "s/127,0,0,1/$(echo "${MANAGE_IP}" | tr '.' ',')/g" /opt/huawei/dj/etc/rabbitmq/rabbitmq.config
sed -i "s/127.0.0.1/${MANAGE_IP}/g" /opt/huawei/dj/etc/rabbitmq/rabbitmq.config
sed -i "s/rabbit@rabbitmqNode0/$(get_host_list)/g" /opt/huawei/dj/etc/rabbitmq/rabbitmq.config
CHECK_RESULT $? "Because of rabbitmq.config file not exist, config failed."
