#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="cli-client"
TIMEOUT=900

function start_backup()
{
    host_ip=$(get_info manage_ip)
    primary_node=$(get_primary_db_node)
    gaussdb_backup_entry="/opt/huawei/dj/tools/backup/gaussdb_backup_entry.sh"
    if [[ "${host_ip}" == "${primary_node}" ]];then
        log_info "current node is the primary."
        bash ${gaussdb_backup_entry} auto "${TIMEOUT}"
        CHECK_RESULT $? "exec gaussdb_backup_entry.sh failed."
    else
        cmd_manager --node_ip "${primary_node}" --cmd "${gaussdb_backup_entry}" --parameters "auto" --parameters "${TIMEOUT}" --timeout "${TIMEOUT}"
        CHECK_RESULT $? "exec gaussdb_backup_entry.sh on ${primary_node} failed."
    fi
    log_info "exec gaussdb_backup_entry.sh success."
    exit 0
}

function enable_backup()
{
    sudo /opt/huawei/root_tools/backup/update_crontab_conf.sh "00:00"
    CHECK_RESULT $? "enable backup failed."
    log_info "enable backup success."
    exit 0
}

function disable_backup()
{
    sudo /opt/huawei/root_tools/backup/update_crontab_conf.sh
    CHECK_RESULT $? "disable backup failed."
    log_info "disable backup success."
    exit 0
}

function main()
{
    cmd="$1"
    case ${cmd} in
        start_backup)
            log_info "receive start_backup cmd."
            if [[ $# -eq 2 ]];then
                if [[ "$2" -gt 0 ]] ;then
                    TIMEOUT="$2"
                else
                    echo "The second parameter indicates the timeout interval. Enter an integer greater than 0." && exit 1
                fi
            fi
            start_backup
            ;;
        enable_backup)
            log_info "receive enable_backup cmd."
            enable_backup
            ;;
        disable_backup)
            log_info "receive disable_backup cmd."
            disable_backup
            ;;
        *)
            log_error "receive invalid cmd"
            ;;
    esac
}
main "$@"
