#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="gaussdb_helper"
SYNC_MONITOR="/opt/huawei/dj/tools/gaussdb/sync_monitor.sh"
GAUSSDB_HELPER="/opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh"
ALARM_RECORD="/opt/huawei/dj/etc/gaussdb/alarm_record"
MAX_ALARM_TIMES=120
MAX_RECOVER_TIMES=120

function send_sync_alarm()
{
    sed -ri "/recover_times=[0-9]+/d" "${ALARM_RECORD}"
    alarm_times=$(grep "alarm_times" "${ALARM_RECORD}" | awk -F "=" '{print $2}')
    if [[ -z ${alarm_times} ]];then
        log_info "Database sync failed 1 times."
        echo "alarm_times=1" >> "${ALARM_RECORD}"
        return
    fi
    if [[ ${alarm_times} -eq ${MAX_ALARM_TIMES} ]];then
        send_alarm 1020715
        log_info "Database sync failed ${alarm_times} times, send alarm ret_code: $?."
        sed -ri "/alarm_times=[0-9]+/d" "${ALARM_RECORD}"
        return
    fi
    alarm_times=$((alarm_times+1))
    sed -ri "s/(alarm_times=)[0-9]+/\1${alarm_times}/g" "${ALARM_RECORD}"
    log_info "Database sync failed ${alarm_times} times."
}


function recover_sync_alarm()
{
    sed -ri "/alarm_times=[0-9]+/d" "${ALARM_RECORD}"
    recover_times=$(grep "recover_times" "${ALARM_RECORD}" | awk -F "=" '{print $2}')
    if [[ -z ${recover_times} ]];then
        log_info "Database sync succeed 1 times."
        echo "recover_times=1" >> "${ALARM_RECORD}"
        return
    fi
    if [[ ${recover_times} -eq ${MAX_RECOVER_TIMES} ]];then
        clear_alarm 1020715
        log_info "Database sync succeed ${recover_times} times, send recover. ret_code:$?"
        sed -ri "/recover_times=[0-9]+/d" "${ALARM_RECORD}"
        return
    fi
    recover_times=$((recover_times+1))
    sed -ri "s/(recover_times=)[0-9]+/\1${recover_times}/g" "${ALARM_RECORD}"
    log_info "Database sync succeed ${recover_times} times."
}

function check_and_reset_status()
{
    touch "${ALARM_RECORD}"
    bash ${SYNC_MONITOR} check_progress >/dev/null 2>&1
    bash ${SYNC_MONITOR} safe_reset_status >/dev/null 2>&1
    local ret=$?
    log_info "Check db sync: ret=${ret}, runState=${runState}."
    if [[ ${ret} -ne 0 ]];then
        send_sync_alarm
    else
        recover_sync_alarm
    fi
    if [[ "${ret}" -ne 0 ]] && [[ "${runState}" == "active" ]];then
       # 当前节点已无法自动升主，尝试切换主备
       /opt/huawei/dj/bin/ha/module/hacom/tools/ha_client_tool --switchover  --name=forceswap >/dev/null 2>&1
       exit 0
    fi
}

function main()
{
    local -i retVal=0
    case "${optCommand}" in
    status)
        bash  ${GAUSSDB_HELPER} "${optCommand}" "${runState}"; retVal=$?
        check_and_reset_status
        return ${retVal}
        ;;
    start)
        bash  ${GAUSSDB_HELPER} "${optCommand}" "${runState}"; retVal=$?
        return ${retVal}
        ;;
    stop)
        bash  ${GAUSSDB_HELPER} "${optCommand}" "${runState}"; retVal=$?
        return ${retVal}
        ;;
    force-stop)
        bash  ${GAUSSDB_HELPER} "${optCommand}" "${runState}"; retVal=$?
        return ${retVal}
        ;;
    active)
        bash ${SYNC_MONITOR} check_status
        CHECK_RESULT $? "The data synchronization status of the current node cannot be changed to the active node."
        bash  ${GAUSSDB_HELPER} "${optCommand}" "${runState}"; retVal=$?
        return ${retVal}
        ;;
    deactive)
        bash  ${GAUSSDB_HELPER} "${optCommand}" "${runState}"; retVal=$?
        return ${retVal}
        ;;
    repair)
        bash  ${GAUSSDB_HELPER} "${optCommand}" "${runState}"; retVal=$?
        return ${retVal}
        ;;
    *)
        log_warn "Operation(${optCommand}) not support."
        return 10
        ;;
    esac
}

declare optCommand="$1"; shift
declare runState="$1";  shift
declare -i scriptRetVal=0
if [[ -f "${GAUSSDB_HELPER}" ]];then
    main ; scriptRetVal=$?
fi
exit ${scriptRetVal}
