#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LD_LIBRARY_PATH=/opt/huawei/dj/bin/gaussdb/app/lib:${LD_LIBRARY_PATH}
export PATH=/opt/huawei/dj/bin/gaussdb/app/bin:${PATH}
export GAUSSHOME=/opt/huawei/dj/bin/gaussdb/app
export PGDATA=/opt/huawei/dj/bin/gaussdb/data
export PGSSLCERT=/opt/huawei/dj/bin/gaussdb/cert/client.crt
export PGSSLKEY=/opt/huawei/dj/bin/gaussdb/cert/client.key
export PGSSLROOTCERT=/opt/huawei/dj/bin/gaussdb/cert/ca-cert.pem
export PGSSLMODE=require
export LOG_TAG="gaussdb_helper"
[[ $# -ne 1 ]] && exit 1
GAUSSUSER=$(get_info gaussdb_admin_user)
GAUSSPASSWORD=$(decrypt_pwd "$(get_info gaussdb_admin_pwd)")
DB_FLOATIP=$(get_info gaussdb_float_ip)
gsql "$1" -U "${GAUSSUSER}" -W "${GAUSSPASSWORD}" -h "${DB_FLOATIP}"