#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

# 防止并发
if [[ "$(pgrep -U 51001 -f "$0" -d ' ')" != "$$" ]];then
     CHECK_RESULT 1 "The script is running, no need start again."
fi


source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="haproxyrun"


HAPROXY_CFG="/opt/huawei/dj/etc/haproxy/haproxy.cfg"
HAPROXY_PID="/opt/huawei/dj/etc/haproxy/haproxy.pid"
PRIVATE_KEY="/opt/huawei/dj/DJSecurity/privkey/privkey.conf"
KEY_PWD="$(awk '{print $2}' "${PRIVATE_KEY}")"
CHECK_RESULT $? "get haproxy pwd failed."
[[ "$1" == "update" ]] && haproxy_regist export --file-name ${HAPROXY_CFG}

function restart_haproxy_with_key()
{
    passwd=$(get_safe_password "$(decrypt_pwd "$KEY_PWD")")
    /usr/bin/expect<<-EOF
    set timeout 600
    spawn /opt/huawei/dj/bin/haproxy/haproxy -D -f ${HAPROXY_CFG} -p ${HAPROXY_PID} -sf $(pgrep -U 51001 -f /opt/huawei/dj/bin/haproxy/haproxy -d " ")
    expect {
        "Enter PEM pass phrase:" {
            send "${passwd}\r"
            exp_continue
        }
        eof { }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function check_haproxy_with_key()
{
    passwd=$(get_safe_password "$(decrypt_pwd "$KEY_PWD")")
    /usr/bin/expect<<-EOF
    set timeout 600
    spawn /opt/huawei/dj/bin/haproxy/haproxy -c -f ${HAPROXY_CFG} -q
    expect {
        "Enter PEM pass phrase:" {
            send "${passwd}\r"
            exp_continue
        }
        eof { }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function modify_haproxy_cfg_forwarded()
{
    sed -i '/option  forwardfor/d' ${HAPROXY_CFG}
    sed -i '/tcp-request connection track-sc1 src/a\    http-request set-header x-forwarded-for "%[src]"' ${HAPROXY_CFG}
}

check_haproxy_with_key
CHECK_RESULT $? "check haproxy cfg failed."
modify_haproxy_cfg_forwarded
restart_haproxy_with_key
CHECK_RESULT $? "Start haproxy pro failed."
log_info "start haproxy pro success"
