#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="karbor-run"

log_info "Start sync kangaroo db"
kangaroo-manage db_sync
CHECK_RESULT $? "Sync kangaroo db failed"
log_info "Sync kangaroo db success"

log_info "Start Add indexes"
kangaroo-manage add_indexes
CHECK_RESULT $? "Add indexes failed"
log_info "Add indexes success"

log_info "Start Init karbor service lock"
kangaroo-manage lock_initial karbor-operationengine
CHECK_RESULT $? "Init karbor service lock failed"
log_info "Init karbor service lock success"

log_info "Start Init karbor rabbitmq lock"
kangaroo-manage lock_initial rabbitmq
CHECK_RESULT $? "Init karbor rabbitmq lock failed"
log_info "Init karbor rabbitmq locks success"