#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="omm-haControl"
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
HA_CONF=/opt/huawei/dj/bin/arbitrationtool/conf/ha.properties
ARB_CONF=/opt/huawei/dj/bin/arbitrationtool/conf/arb.properties
RST_FILE=/opt/huawei/dj/bin/ha/local/conf/arbRst
HA_ARB_CONF=/opt/huawei/dj/bin/ha/module/haarb/conf/haarb.xml
g_arbInterval=
g_arbValidTime=
g_arbFreq=
g_arbKeepalive=
g_localDcStatus=
g_remoteDcStatus=
g_match=

#****************************************#
# Function: get the arbitration interval
# Usage: getArbInterval
# Parameters:
# None
# Return: return 0 on success, non 0 on failed
#****************************************#
function getArbInterval()
{
    queryType=$1
    g_arbInterval=$(grep "arbInterval=" ${HA_CONF} | awk -F "=" '{print $2}')
    g_arbValidTime=$(grep "arbValidTime=" ${HA_CONF} | awk -F "=" '{print $2}')
    if [[ ${g_arbInterval} -eq 0 ]] || [[ "${g_arbInterval}" = "0" ]] || [[ ${g_arbValidTime} -eq 0 ]] || [[ "${g_arbValidTime}" = "0" ]];then
        log_error "Get arbitration configuration failed."
        return 1
    fi
    g_arbKeepalive=$(grep "keepalive" ${HA_ARB_CONF} | awk -F "value=" '{print $2}' | awk -F "\"" '{print $2}')
    if [[ ${g_arbKeepalive} -eq 0 ]] || [[ "${g_arbKeepalive}" = "0" ]];then
        log_error "Get HA value of keepalive configuration failed."
        return 1
    fi
    if [[ "$queryType" -eq "1" ]];then
        # heartbeat break, query arbitration result, when heartbeat break, have spend some seconds, configured in haarb.xml
        # when computing interval, must minus this seconds 
        num=$((g_arbValidTime-g_arbKeepalive))
        g_arbFreq=$((num/g_arbInterval))
        g_arbFreq=$((g_arbFreq+1))
    else
        g_arbFreq=$((g_arbValidTime/g_arbInterval))
    fi
    if [[ ${g_arbFreq} -eq 0 ]] || [[ "${g_arbFreq}" = "0" ]];then
        log_error "Compute frequency failed, validate:${g_arbValidTime}, g_arbKeepalive:${g_arbKeepalive}, g_arbInterval:${g_arbInterval}."
        return 1
    fi
    return 0
}

function execute_query()
{
    #localDcStatus:ok
    #remoteDcStatus:ok
    #isMatch:true
    checkArb > "${CURRENT_PATH}/result.tmp"
    grep "localDcStatus:" "${CURRENT_PATH}/result.tmp"  || return 1
    grep "remoteDcStatus:" "${CURRENT_PATH}/result.tmp" || return 1
    grep "isMatch:" "${CURRENT_PATH}/result.tmp" || return 1
    while read -r data;do
        g_localDcStatus=$(echo "${data}" | grep "localDcStatus:" | awk -F ":" '{print $2}')
        g_remoteDcStatus=$(echo "${data}" | grep "remoteDcStatus:" | awk -F ":" '{print $2}')
        g_match=$(echo "${data}" | grep "isMatch:" | awk -F ":" '{print $2}')
    done < "${CURRENT_PATH}/result.tmp"
    if [[ -z "${g_localDcStatus}" ]] || [[ -z "${g_remoteDcStatus}" ]] || [[ -z "${g_match}" ]];then
        log_error "Query arbitration result failed."
        return 1
    fi
    rm -f "${CURRENT_PATH}/result.tmp"
    return 0
}

#****************************************#
# Function: get the arbitration result
# Usage: getArbRst
# Parameters:
# None
# Return: return 0 on success, non 0 on failed
#****************************************#
function getArbRst()
{
    # get query frequency and interval
    getArbInterval "$1"
    CHECK_RESULT $? "Get arbitration interval failed."
    log_info "g_arbFreq=${g_arbFreq}."
    #echo CLASSPATH=$CLASSPATH
    lastLocalRst=
    lastRemoteRst=
    timeValue=0
    repeatTime=1
    queryTime=0
    while true
    do
        if [[ ${timeValue} -ge 180 ]];then
            log_error "Query arbitration result timeout."
            exit 1
        fi
        queryTime=$((queryTime+1))
        if execute_query;then
            log_error "Query arbitration result failed, time=${queryTime}."
            timeValue=$((timeValue+g_arbInterval))
            sleep "${g_arbInterval}"
            continue
        fi
        if [[ "${g_match}" != "true" ]];then
            log_error "Arbitration result is not match, local=${g_localDcStatus}, remote=${g_remoteDcStatus}, match:${g_match}, time=${queryTime}."
            timeValue=$((timeValue+g_arbInterval))
            sleep "${g_arbInterval}"
            continue
        fi
        if [[ "${lastLocalRst}" = "${g_localDcStatus}" ]] && [[ "${lastRemoteRst}" = "${g_remoteDcStatus}" ]];then
            repeatTime=$((repeatTime+1))
            timeValue=0
        else
            log_error "Result have changed query_time=${queryTime}, repeat_time=${repeatTime}, last local=${lastLocalRst}, remote=${lastRemoteRst}, new local=${g_localDcStatus}, remote=${g_remoteDcStatus}"
            repeatTime=1
            lastLocalRst=${g_localDcStatus}
            lastRemoteRst=${g_remoteDcStatus}
            timeValue=0
        fi
        if [[ "$repeatTime" -ge "${g_arbFreq}" ]];then
            log_info "Have get right result, local=${g_localDcStatus}, remote=${g_remoteDcStatus}, time=${queryTime}."
            break
        fi
        timeValue=$((timeValue+g_arbInterval))
        sleep "${g_arbInterval}"
    done
    echo "localDCStatus=${g_localDcStatus}" > ${RST_FILE}
    echo "remoteDCStatus=${g_remoteDcStatus}" >> ${RST_FILE}
}

# query type, 0:clear flag query   1:heartbeat break, query arbitration result 
queryType="$1"
if [[ "${queryType}" != "1" ]] && [[ "${queryType}" != "0" ]]; then
    echo_error "queryType isn't right."
    exit 1
fi
arb_enable=$(get_pwd arb.enable ${ARB_CONF})
[[ "${arb_enable}" == "false"  ]] && log_info "arb.enable is false."  && exit 0
getArbRst "${queryType}"
CHECK_RESULT $? "Get arbitration result failed."
log_info "Get arbitration result success."
exit 0
