#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LD_LIBRARY_PATH=/opt/huawei/dj/bin/gaussdb/app/lib:${LD_LIBRARY_PATH}
export PATH=/opt/huawei/dj/bin/gaussdb/app/bin:${PATH}
export GAUSSHOME=/opt/huawei/dj/bin/gaussdb/app
export PGDATA=/opt/huawei/dj/bin/gaussdb/data
export PGSSLCERT=/opt/huawei/dj/bin/gaussdb/cert/client.crt
export PGSSLKEY=/opt/huawei/dj/bin/gaussdb/cert/client.key
export PGSSLROOTCERT=/opt/huawei/dj/bin/gaussdb/cert/ca-cert.pem
export PGSSLMODE=require
export LOG_TAG="config_db_user"
GAUSSUSER=$(get_info gaussdb_admin_user)
GAUSSPASSWORD=$(decrypt_pwd "$(get_info gaussdb_admin_pwd)")

gs_guc set -h "local all all  trust"
gs_ctl reload

result=$(gsql postgres -h /opt/huawei/dj/bin/gaussdb -c "alter user ${GAUSSUSER} with password \"${GAUSSPASSWORD}\""; 2 > "$1")

gs_guc set -h "local all all  sha256"
gs_ctl reload

if [[ "$result" == *"ERROR"* ]]; then
    exit 1
fi

exit 0