#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="resource_manager_start"
HOST_IP=$(get_info manage_ip)

function args_err()
{
    echo -e "resource_managerControl: illegal option"
    showhelp
}

function showhelp()
{
    usage="Usage: resource_managerControl"
    len=${#usage}
    echo "Usage: resource_managerControl [-S RUN]"
    printf "%-${len}s [-S STOP]\n"
    printf "%-${len}s [-A RESTART]\n"
    printf "%-${len}s [-CS ComponentState]\n"
    printf "%-${len}s [-h]\n"
    exit 1
}

function start_heartbeat_and_register_haproxy()
{
    haproxy_regist add --frontend-name karbor --plane internal  --frontend-port 8799 \
    --backend-name resource_manager --server-ip "${HOST_IP}" --server-port 28899 \
    --backend-param mode=http --backend-param balance=roundrobin --backend-param option=tcpka \
    --backend-param stats=hide-version --backend-param option=httpchk --backend-param option=httplog \
    --backend-param "acl=hdr(X-MicroVersion) -i 1.2" >/dev/null 2>&1
    echo_info "Finish register ${HOST_IP}:28899, return_code:$?"
    echo_info "$(heartBeat START resource_manager)"
}

function component_run()
{
    echo_info "Run resource_manager begin"
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/resource_manager-api)
    if [[ -n "${queryCmd}" ]]; then
        start_heartbeat_and_register_haproxy
        echo_info "resource_manager process is running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        proc_manager --filename resource_manager-api
        sleep 10
        queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/resource_manager-api)
        if [[ -z "${queryCmd}" ]]; then
            log_warn "resource_manager process is not running when start, retry."
            continue
        fi
        start_heartbeat_and_register_haproxy
        echo_info "start resource_manager successfully."
        return 0
    done
    ECHO_RETURN 1 "start resource_manager failed."
}

function stop_heartbeat_and_unregister_haproxy()
{
    echo_info "$(heartBeat STOP resource_manager)"
    haproxy_regist delete --frontend-name karbor --plane internal --frontend-port 8799 \
    --backend-name resource_manager --server-ip "${HOST_IP}" --server-port 28899 >/dev/null 2>&1
    echo_info "Finish unregister ${HOST_IP}:28899, return_code:$?"
}

function component_stop()
{
    echo_info "Stop resource_manager begin"
    query_exec_Cmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/resource_manager-api)
    if [[ -z "${query_exec_Cmd}" ]]; then
        stop_heartbeat_and_unregister_haproxy
        echo_info "resource_manager process is not running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        kill_process /opt/huawei/dj/sbin/resource_manager-api
        sleep 5
        query_exec_Cmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/resource_manager-api)
        if [[ -n "${query_exec_Cmd}" ]]; then
            log_warn "resource_manager process is running when stop, retry."
            continue
        fi
        stop_heartbeat_and_unregister_haproxy
        echo_info "stop resource_manager successfully."
        return 0
    done
    ECHO_RETURN 1 "stop resource_manager failed."
}

function component_restart()
{
    echo_info "resource_manager restart begin."
    component_stop
    sleep 5
    component_run
    echo_info "resource_manager restart end."
}

function get_component_status()
{
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/resource_manager-api)
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "resource_manager process is not running."
    fi
    curl -i -k "https://${HOST_IP}:28899" >/dev/null 2>&1
    ECHO_RETURN $? "resource_manager port 28899 unreachable ."
    echo_info "resource_manager process is running."
    exit 0
}

case "$1 '$2' $#" in
    "-S 'RUN' 2")
        Action1=$2
        ;;
    "-S 'STOP' 2")
        Action1=$2
        ;;
    "-A 'RESTART' 2")
        Action2=$2
        ;;
    "-CS 'ComponentState' 2")
        Action3=$2
        ;;
    "-h '' 1")
        showhelp
        ;;
    *)
        args_err
        ;;
esac
if [[ "ComponentState" == "${Action3}" ]]; then
    get_component_status
elif [[ "RESTART" == "${Action2}" ]]; then
    component_restart
elif [[ "RUN" == "${Action1}" ]]; then
    component_run
elif [[ "STOP" == "${Action1}" ]]; then
    component_stop
fi
exit 0