#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="zookeeperControl"
[[ "$1" != "ascagent.zookeeper.zk_client_pwd" ]] && CHECK_RESULT 1 "$1 is not zookeeper watcher key."

zookeeper_auth_info=$(get_cms_info "$1")
if [[ -z "${zookeeper_auth_info}" ]];then
    CHECK_RESULT 1 "get zookeeper auth info from cms failed."
fi
zookeeper_auth=$(get_dict_info "${zookeeper_auth_info}" "zookeeper_auth")
if [[ -z "${zookeeper_auth}" ]];then
    CHECK_RESULT 1 "get zookeeper auth data from cms failed."
fi
echo "${zookeeper_auth}" | xargs | grep -E "^[A-F0-9#]+$">/dev/null
CHECK_RESULT $? "Incorrect account. Please try again."
sed -i "s/authData=.*/authData=${zookeeper_auth}/" /opt/huawei/dj/etc/zookeeper/zkClient.conf
decrypt_zk_passpwd=$(decrypt_pwd "${zookeeper_auth}")
zk_passpwd_hash=$(hash_password "${decrypt_zk_passpwd}")
sed -i "s/authDataHash=.*/authDataHash=${zk_passpwd_hash}/" /opt/huawei/dj/etc/zookeeper/zkClient.conf
zookeeperControl -A RESTART
log_info "update zookeeper client pwd finished."