/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.adapter.service.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussCluster;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussLunInfo;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationDiscoverer;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.opengauss.constant.OpenGaussEumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenGaussManagerImpl
implements IApplicationManager,
IApplicationDiscoverer {
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussManagerImpl.class);
    private INeMgrProtocolExtendService neMgr;

    public List<ManagedObject> discoverApplication(NeMgrProtocolExtend extend) {
        if (VerifyUtil.isEmpty((Object)extend)) {
            LOGGER.error((Object)"Extend is null.");
            return Collections.emptyList();
        }
        LOGGER.info((Object)"Start discover opengauss cluster on ip: %s.", new Object[]{extend.getNetworkIpAddress()});
        String macAddress = (String)extend.getExtendParams().get("mac_address");
        OpenGaussAction action = new OpenGaussAction(extend, macAddress);
        List<OpenGaussCluster> queryResult = action.queryClusters();
        if (VerifyUtil.isEmpty(queryResult)) {
            LOGGER.info((Object)"Discover opengauss cluster is empty, ip: %s.", new Object[]{extend.getNetworkIpAddress()});
            return Collections.emptyList();
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (OpenGaussCluster cluster : queryResult) {
            OpenGaussCluster oldCluster = (OpenGaussCluster)moDao.getMo(OpenGaussCluster.class, "uuid", (Object)cluster.getUuid());
            if (oldCluster == null) continue;
            Map newProps = cluster.getProps();
            Map oldProps = oldCluster.getProps();
            oldProps.put("nodeName", newProps.get("nodeName"));
            oldProps.put("nodeConfig", newProps.get("nodeConfig"));
            oldProps.put("remoteIp", newProps.get("remoteIp"));
            oldProps.put("localIp", newProps.get("localIp"));
            cluster.setProps(oldProps);
        }
        LOGGER.info((Object)"End discover opengauss cluster result on %s.", new Object[]{extend.getNetworkIpAddress()});
        return new ArrayList<OpenGaussCluster>(queryResult);
    }

    public void freeze(ProtectObject protectObject) {
    }

    public void thaw(ProtectObject protectObject) {
    }

    public void launch(ProtectObject protectObject) {
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)protectObject.getProviderSN());
        OpenGaussAction opAction = new OpenGaussAction(ne, (String)ne.getExtendParams().get("mac_address"));
        String clusterUser = (String)protectObject.getProps().get("USERNAME");
        VerifyUtil.checkStrs((String[])new String[]{clusterUser});
        opAction.startCluster(clusterUser);
    }

    public void suspend(ProtectObject protectObject) {
    }

    public void testConnecting(ProtectObject protectObject) {
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)protectObject.getProviderSN());
        OpenGaussAction opAction = new OpenGaussAction(ne, (String)ne.getExtendParams().get("mac_address"));
        String clusterUser = (String)protectObject.getProps().get("USERNAME");
        String clusterUserPwd = (String)protectObject.getProps().get("PASSWD");
        VerifyUtil.checkStrs((String[])new String[]{clusterUser});
        if (VerifyUtil.isEmpty((String)clusterUserPwd)) {
            opAction.testConnection(clusterUser);
        } else {
            opAction.testConnection(clusterUser, WccEncryptor.decrypt((String)clusterUserPwd));
        }
    }

    public void generateLUNDetail(ProtectObject protectObject) {
        String clusterUser = (String)protectObject.getProps().get("USERNAME");
        VerifyUtil.checkStrs((String[])new String[]{clusterUser});
        protectObject.setPoType(19);
        if (VerifyUtil.isEmpty((String)protectObject.getUuid())) {
            protectObject.setUuid(UUIDGenerator.getUUID());
        }
        protectObject.clearUsedStorageResource();
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)protectObject.getProviderSN());
        OpenGaussAction opAction = new OpenGaussAction(ne, (String)ne.getExtendParams().get("mac_address"));
        JSONObject lunInfoJsonObj = opAction.queryLunList(clusterUser);
        if (VerifyUtil.isEmpty((Map)lunInfoJsonObj)) {
            LOGGER.error((Object)"Lun info is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Set<ProtectObjectStorageInfo> usedPoStorage = this.convertToPoStorageInfos(protectObject, lunInfoJsonObj, "local_xlog_disks");
        protectObject.setUsedStorageResourceSet(usedPoStorage);
        this.updatePoPropWithLunInfo(protectObject, "DATA_DISKS", lunInfoJsonObj, "data_disks");
        this.updatePoPropWithLunInfo(protectObject, "SHARED_DISKS", lunInfoJsonObj, "shared_disks");
        this.updatePoPropWithLunInfo(protectObject, "VOTING_DISKS", lunInfoJsonObj, "voting_disks");
    }

    public void updatePoPropWithLunInfo(ProtectObject protectObject, String propKey, JSONObject lunInfoJsonObj, String lunInfoKey) {
        if (!lunInfoJsonObj.containsKey((Object)lunInfoKey)) {
            LOGGER.error((Object)"Cant find lun info for cluster: %s", new Object[]{lunInfoKey});
            throw new LegoCheckedException(1073947393L);
        }
        Set<ProtectObjectStorageInfo> poStorageInfoSet = this.convertToPoStorageInfos(protectObject, lunInfoJsonObj, lunInfoKey);
        JSONArray jsonArray = new JSONArray();
        poStorageInfoSet.stream().map(ProtectObjectStorageInfo::toJSONObject).forEach(arg_0 -> ((JSONArray)jsonArray).add(arg_0));
        protectObject.getProps().put(propKey, jsonArray.toString());
    }

    private Set<ProtectObjectStorageInfo> convertToPoStorageInfos(ProtectObject protectObject, JSONObject lunInfoJsonObj, String lunInfoKey) {
        HashSet<ProtectObjectStorageInfo> usedPoStorage = new HashSet<ProtectObjectStorageInfo>();
        JSONArray lunInfoJsonArr = lunInfoJsonObj.getJSONArray(lunInfoKey);
        for (Object jsonObj : lunInfoJsonArr) {
            JSONObject sharedDisk = JSONObject.fromObject(jsonObj);
            ProtectObjectStorageInfo poStorageInfo = this.transitionToPoStorageObj(protectObject, sharedDisk);
            usedPoStorage.add(poStorageInfo);
        }
        return usedPoStorage;
    }

    private ProtectObjectStorageInfo transitionToPoStorageObj(ProtectObject protectObject, JSONObject lunInfoObj) {
        ProtectObjectStorageInfo poStorageInfo = new ProtectObjectStorageInfo();
        poStorageInfo.setLunWWN(JsonUtil.getString((JSONObject)lunInfoObj, (String)"wwn", (String[])new String[]{""}));
        String arraySn = JsonUtil.getString((JSONObject)lunInfoObj, (String)"arraySn", (String[])new String[]{""});
        if (!VerifyUtil.isEmpty((String)arraySn) && arraySn.length() > 20) {
            arraySn = arraySn.substring(0, 20);
        }
        poStorageInfo.setResourceProviderSN(arraySn);
        poStorageInfo.setDeviceName(JsonUtil.getString((JSONObject)lunInfoObj, (String)"deviceName", (String[])new String[]{""}));
        poStorageInfo.setHostSN(protectObject.getProviderSN());
        String transportProtocol = JsonUtil.getString((JSONObject)lunInfoObj, (String)"transportProtocol", (String[])new String[]{""});
        String protocol = OpenGaussUtil.getProtocol(transportProtocol);
        Lun xlogLun = OpenGaussManagerImpl.getLunByProtocol(poStorageInfo, protocol);
        poStorageInfo.setResourceId(xlogLun.getLunId());
        poStorageInfo.setLunWWN(xlogLun.getWwn());
        poStorageInfo.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        poStorageInfo.setAlias(protocol + ":" + poStorageInfo.getResourceId());
        String vendor = JsonUtil.getString((JSONObject)lunInfoObj, (String)"Vendor", (String[])new String[]{""});
        poStorageInfo.setStorageType(Integer.valueOf("HUAWEI".equalsIgnoreCase(vendor) ? DrmEnumDefine.StorageTypeE.NORMAL.getValue() : DrmEnumDefine.StorageTypeE.UNKNOWN.getValue()));
        poStorageInfo.setIsManualConfigLun(Boolean.valueOf(true));
        poStorageInfo.setId(UUIDGenerator.getUUID());
        return poStorageInfo;
    }

    private static Lun getLunByProtocol(ProtectObjectStorageInfo poStorageInfo, String protocol) {
        IStorageService service = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        Lun xlogLun = null;
        if (DrmEnumDefine.InitiatorType.FC.getName().equals(protocol)) {
            xlogLun = (Lun)service.getLunByWwn(poStorageInfo.getResourceProviderSN(), Collections.singleton(poStorageInfo.getLunWWN())).stream().findFirst().orElseThrow(() -> new LegoCheckedException(1073948705L));
        } else if (DrmEnumDefine.InitiatorType.NVME_OVER_ROCE.getName().equals(protocol)) {
            xlogLun = (Lun)service.getLunByNguid(poStorageInfo.getResourceProviderSN(), Collections.singleton(poStorageInfo.getLunWWN())).stream().findFirst().orElseThrow(() -> new LegoCheckedException(1073948705L));
        } else {
            LOGGER.error((Object)"Unsupported protocol: %s", new Object[]{protocol});
            throw new LegoCheckedException(1073949738L);
        }
        return xlogLun;
    }

    public Set<ProtectObject> combineProtectObject(Set<ProtectObject> set) {
        return new HashSet<ProtectObject>();
    }

    public void checkEnvForFreeze(ProtectObject protectObject) {
    }

    public int getAppType() {
        return 19;
    }

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public boolean isPrimary(String sn, String clusterUser) {
        NeMgrProtocolExtend ne = this.neMgr.findBySn(sn);
        OpenGaussAction action = new OpenGaussAction(ne, sn);
        return action.isPrimary(clusterUser);
    }

    public boolean isMainStandby(String sn, String clusterUser) {
        NeMgrProtocolExtend ne = this.neMgr.findBySn(sn);
        OpenGaussAction action = new OpenGaussAction(ne, sn);
        return action.isMainStandby(clusterUser);
    }

    public String buildCheck(String hostSn, String clusterUser) {
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)hostSn);
        OpenGaussAction action = new OpenGaussAction(ne, (String)ne.getExtendParams().get("mac_address"));
        return action.buildCheck(clusterUser);
    }

    public boolean execBuild(String hostSn, String clusterUser, OpenGaussEumDefine.BuildType buildType) {
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)hostSn);
        OpenGaussAction action = new OpenGaussAction(ne, (String)ne.getExtendParams().get("mac_address"));
        return action.execBuild(clusterUser, buildType);
    }

    public void stopCluster(String hostSn, String clusterUser) {
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)hostSn);
        OpenGaussAction action = new OpenGaussAction(ne, (String)ne.getExtendParams().get("mac_address"));
        action.stopCluster(clusterUser);
    }

    public void startCluster(String hostSn, String clusterUser) {
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)hostSn);
        OpenGaussAction action = new OpenGaussAction(ne, (String)ne.getExtendParams().get("mac_address"));
        action.startCluster(clusterUser);
    }

    public void configLunInfo(String hostSn, String clusterUser, OpenGaussLunInfo lunInfo) {
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)hostSn);
        OpenGaussAction action = new OpenGaussAction(ne, (String)ne.getExtendParams().get("mac_address"));
        action.configLunInfo(clusterUser, lunInfo);
    }
}

